<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Router\Route;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;
$doc = FactoryAlias::getDocument();

$appConfig = FactoryAlias::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = HtmlFrontend::is_multi_product_in_cart();
if(!empty((array)($this->item))) {
    $open_time = isset($this->item->open_time)?$this->item->open_time:'';
    $open_time= date('h:i A',strtotime($open_time));
    $close_time= isset($this->item->close_time)?$this->item->close_time:'';
    $close_time= date('h:i A',strtotime($close_time));
    $working_day= isset($this->item->working_day)?$this->item->working_day:'';
    $working_day= trim($working_day) !== ''?json_decode($working_day):array();

    $rating_ambience = isset($this->item->rating_ambience)?$this->item->rating_ambience:0;
    $rating_cleanliness=isset($this->item->rating_cleanliness)?$this->item->rating_cleanliness:0;
    $rating_staff = isset($this->item->rating_staff)?$this->item->rating_staff:0;
    $rating_value = isset($this->item->rating_value)?$this->item->rating_value:0;
    $rating_avg=isset($this->item->rating_avg)?$this->item->rating_avg:0;

    $list_star_ambience = HtmlFrontend::get_rating_star($rating_ambience);
    $list_star_cleanliness = HtmlFrontend::get_rating_star($rating_cleanliness);
    $list_star_staff = HtmlFrontend::get_rating_star($rating_staff);
    $list_star_value = HtmlFrontend::get_rating_star($rating_value);
    $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);

    $list_review = isset($this->item->list_review)?$this->item->list_review:array();

    $one_star = array();
    $two_star = array();
    $three_star = array();
    $four_star = array();
    $five_star = array();
    if(!empty($list_review)) {
        $rating_sum = 0;
        foreach ($list_review as $review) {
            if(isset($review->avg_rating)) {
                $rating_sum += $review->avg_rating;
            }
            if(isset($review->avg_rating)) {
                if($review->avg_rating > 0 && $review->avg_rating <= 1) {
                    array_push($one_star, $review);
                } elseif($review->avg_rating > 1 && $review->avg_rating <= 2) {
                    array_push($two_star, $review);
                } elseif($review->avg_rating > 2 && $review->avg_rating <= 3) {
                    array_push($three_star, $review);
                } elseif($review->avg_rating > 3 && $review->avg_rating <= 4) {
                    array_push($four_star, $review);
                } elseif($review->avg_rating > 4 && $review->avg_rating <= 5) {
                    array_push($five_star, $review);
                }
            }
        }
        $max_star = 5;
        $service_rating=$rating_sum / count($list_review);
        while ($service_rating > $max_star) {
            $service_rating = $service_rating - $max_star;
        }

        $star = $service_rating % 10;
        $non_star = ($max_star - $service_rating) % 10;
        $half_star = ceil($max_star-$star-$non_star);

    }
}else {
    $list_review = array();
}

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();


$page_list_service= ConfigHelperAlias::get_page_list_service();
if($page_list_service) {
    $this->page_list_service = get_page_link($page_list_service);
}else{
    $this->page_list_service="";
}
$page_list_category= ConfigHelperAlias::get_page_list_category();
if($page_list_category) {
    $this->page_list_category = get_page_link($page_list_category);
}else{
    $this->page_list_category="";
}

$page_service_detail= ConfigHelperAlias::get_page_service_detail();
if($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
}else{
    $this->page_service_detail="";
}
$page_vendor_detail= ConfigHelperAlias::get_page_vendor_detail();
if($page_vendor_detail) {
    $this->page_vendor_detail = get_page_link($page_vendor_detail);
}else{
    $this->page_vendor_detail="";
}

if(isset($this->user) && $this->user) {
    $user = $this->user;
} else {
    $user = new \stdClass();
}

$limit = 6;

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();

$appConfig = FactoryAlias::getAppConfig();
$default_currency = $appConfig->get('default_currency','');
$current_currency = isset($_SESSION['currency'])?$_SESSION['currency']: $default_currency;


?>
    <div class="view-service-detail">
        <?php if(!empty((array)($this->item))) { ?>

            <div class="bread-crumb">
                <a class="link-category" href="<?php esc_html_e($this->page_list_category) ?>"><?php esc_attr_e('Category','wpbookingpro')?></a>
                <i class="icon-nb-down-arrow"></i>
                <a class="link-category" href="<?php echo (esc_url($this->page_list_service.'?category='.isset($this->item->category)?$this->item->category->id:'')) ?>"><?php esc_html_e(isset($this->item->category)?$this->item->category->name:'');?></a>
                <i class="icon-nb-down-arrow"></i>
                <span><?php esc_html_e($this->item->name);?></span>
            </div>
            <div class="block-alert"></div>
            <div class="row">
                <div class="col-md-12">
                    <div class="block-title-service">
                        <h2><?php esc_html_e($this->item->name);?></h2>
                        <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-8">
                    <div class="wrapper-gallery-slider">
                            <a class="arrow-prev"><i class="icon-nb-down-arrow"></i></a>
                            <a class="arrow-next"><i class="icon-nb-down-arrow"></i></a>
                            <div class="block-gallery-slider-large">
                                <?php foreach ($this->item->list_image as $image) { ?>
                                    <div class="img-gallery-large">
                                        <div>
                                            <?php $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $image->path);?>
                                            <?php if($check_user_demo['is_demo']) {?>
                                                <?php if($check_image_size) {?>
                                                    <img src="<?php echo (esc_url($uploads['baseurl'].'/'.$image->path)) ?>" alt="image-gallery">
                                                <?php } else {?>
                                                    <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$image->path)) ?>" alt="image-gallery">
                                                <?php } ?>

                                            <?php } else {?>
                                                <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$image->path)) ?>" alt="image-gallery">
                                            <?php } ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="block-gallery-slider-small">
                                <?php foreach ($this->item->list_image as $image) { ?>
                                    <div class="gallery-img-box">
                                        <div>
                                            <?php $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $image->path);?>
                                            <?php if($check_user_demo['is_demo']) {?>
                                                <?php if($check_image_size) {?>
                                                    <img class="demo cursor" src="<?php echo (esc_url($uploads['baseurl'].'/'.$image->path)) ?>" alt="image-gallery">
                                                <?php } else {?>
                                                    <img class="demo cursor" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$image->path)) ?>" alt="image-gallery">
                                                <?php } ?>
                                            <?php }else {?>
                                                <img class="demo cursor" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$image->path)) ?>" alt="image-gallery">
                                            <?php }?>
                                        </div>
                                    </div>
                                <?php }?>
                            </div>
                        </div>
                    <div class="service-information">
                        <p><?php echo(html_entity_decode($this->item->description));?></p>
                    </div>
                    <form action="" method="post" class="booking-form" name="client-form" enctype="multipart/form-data">
                        <div class="block-booking-information">
                            <h5><?php esc_attr_e('Select expert','wpbookingpro')?></h5>
                            <?php
                            $field = $this->form->getField('employee_id');
                            echo($field->input);
                            ?>
                            <h5><?php esc_attr_e('Select time','wpbookingpro')?></h5>
                            <?php
                            $field = $this->form->getField('calendar');
                            echo($field->input);
                            ?>
                        </div>
                        <?php if ($booking_style == "in_line") { ?>
                            <div class="wrapper-block-check-out">
                                <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="infor-payment-left">
                                            <p><?php esc_attr_e('Expert','wpbookingpro') ?>: <span class="trainer-info"></span></p>
                                            <p><?php esc_attr_e('Local time','wpbookingpro') ?>: <span class="local-time"></span></p>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="info-payment-right">
                                            <p><?php esc_attr_e('Date','wpbookingpro') ?>: <span class="date-info"></span></p>
                                            <p><?php esc_attr_e('Location','wpbookingpro') ?>: <span class="location-info"><?php echo(isset($this->item->location->address)?$this->item->location->address:'')?></span></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="block-check-out">
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <div class="input-firstname">
                                                <?php
                                                $field = $this->form->getField('first_name');
                                                $field->setValue(isset($user->data->user_plugin->first_name)?$user->data->user_plugin->first_name:'');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <div class="input-lastname">
                                                <?php
                                                $field = $this->form->getField('last_name');
                                                $field->setValue(isset($user->data->user_plugin->last_name)?$user->data->user_plugin->last_name:'');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <div class="input-email">
                                                <?php
                                                $field = $this->form->getField('email');
                                                $field->setValue(isset($user->data->user_plugin->email)?$user->data->user_plugin->email:'');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <div class="input-phone">
                                                <?php
                                                $field = $this->form->getField('phone');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="block-select-payment">
                                    <?php
                                    $field = $this->form->getField('open_source_payment_id');
                                    $disable_payment_online = isset($this->item->disable_payment_online) ? (boolean)$this->item->disable_payment_online : false;

                                    $field->setDisablePaymentOnline($disable_payment_online);
                                    ?>
                                    <h6><?php esc_attr_e('Select payment','wpbookingpro')?></h6>
                                    <?php echo($field->input); ?>
                                </div>
                                <div class="block-select-payment-schedule">
                                    <h6><?php esc_html_e('Select payment schedule','wpbookingpro')?></h6>
                                    <div class="block-payment-schedule-item">
                                        <label>
                                            <input type="radio" name="payment_schedule" value="pay-now" />
                                            <?php esc_html_e('Pay now','wpbookingpro')?>
                                        </label>
                                    </div>
                                    <div class="block-payment-schedule-item">
                                        <label>
                                            <input type="radio" name="payment_schedule" value="pay-later" />
                                            <?php esc_html_e('Pay later','wpbookingpro')?>
                                        </label>
                                        <div class="deposit-block" style="display:none;">
                                            <span><?php esc_html_e('Deposit','wpbookingpro');?></span>
                                            <div class="deposit-percent">
                                                <span><?php echo (esc_html(isset($this->item->deposit_percent)?$this->item->deposit_percent:''))?></span>
                                                <span><?php echo (esc_html('%'))?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="deposit_percent" value="">

                                </div>
                                <div class="wrapper-block-add-coupon">
                                    <h6><?php esc_html_e('Add coupon code (optional)','wpbookingpro')?></h6>
                                    <div class="block-add-coupon">
                                        <input type="text" class="input-coupon">
                                        <button type="button" class="add-coupon" disabled><?php esc_html_e('Apply','wpbookingpro');?></button>
                                        <input type="hidden" name="coupon_id">
                                    </div>
                                    <div class="alert alert-danger alert-dismissible message-error" role="alert" style="display:none;">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <?php esc_html_e('The coupon code is invalid or expired','wpbookingpro');?>
                                    </div>
                                    <div class="alert alert-success alert-dismissible message-success" role="alert" style="display:none;">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <?php esc_html_e('Coupon code applied successfully','wpbookingpro');?>
                                    </div>
                                </div>
                                <div class="block-payment-item">
                                    <h4><?php esc_attr_e('Payment info','wpbookingpro') ?></h4>
                                    <div class="detail-payment-item">
                                        <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                        <span class="number-person">1</span>
                                    </div>
                                    <div class="detail-payment-item total-day-recurring" style="display: none">
                                        <span><?php esc_attr_e('Total day recurring','wpbookingpro') ?>:</span>
                                        <span class="sum-day-recurring">1</span>
                                    </div>
                                    <div class="detail-payment-item">
                                        <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                        <span class="base-price"><?php echo (FrontendHelper::format_currency(number_format((float)$this->item->price,2)))?></span>
                                    </div>
                                    <div class="detail-payment-item payment-deposit" style="display: none">
                                        <span><?php esc_attr_e('Deposit payment','wpbookingpro') ?>:</span>
                                        <span class="deposit"></span>
                                    </div>
                                    <div class="detail-payment-item payment-balance" style="display: none">
                                        <span><?php esc_attr_e('Balance payment','wpbookingpro') ?>:</span>
                                        <span class="balance"></span>
                                    </div>
                                    <div class="detail-payment-item discount" style="display: none">
                                        <span><?php esc_attr_e('Discount','wpbookingpro') ?>:</span>
                                        <span class="discount-value"></span>
                                    </div>
                                    <div class="detail-payment-item total-cost">
                                        <span><?php esc_attr_e('Total','wpbookingpro') ?>:</span>
                                        <span class="total-cost-sum"><?php echo (FrontendHelper::format_currency(number_format((float)$this->item->price,2)))?></span>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="wrapper-btn-checkout">
                            <button type="button" class="btn btn-danger btn-book-now">
                                <span><?php esc_attr_e('Book now','wpbookingpro') ?></span>
                            </button>
                        </div>
                        <input type="hidden" name="task" value="booking.book_service">
                        <input type="hidden" name="service_id" value="<?php esc_html_e($this->item->id) ?>" />
                        <input type="hidden" name="product_id" value="<?php esc_html_e($this->item->open_source_link_id) ?>" />
                        <input type="hidden" name="event_id" value="" />
                    </form>
                    <div class="rating-review">
                        <div class="title">
                            <h4> <?php esc_html_e('Add review','wpbookingpro');?> </h4>
                            <div class="line"></div>
                        </div>
                        <div class="row">
                            <div class="col-md-5">
                                <div class="title-rating">
                                    <h4><?php esc_html_e('Ratings','wpbookingpro');?></h4>
                                </div>
                                <div class="quality-star">
                                    <div class="number-star">
                                        <span><?php echo (!empty($list_review)?number_format((float)$service_rating,2):0);?></span>
                                    </div>
                                    <span class="text-star">
                                            <span><?php esc_html_e('Overall Rating of','wpbookingpro');?></span>
                                            <span><?php echo (esc_html(count($list_review)));?></span>
                                            <span><?php esc_html_e('guest rating', 'wpbookingpro');?></span>
                                    </span>
                                </div>
                                <div class="overall-rating">
                                    <div class="block-item-rating">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 5; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($five_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($five_star)/count($list_review):0);?>)">
                                            </div>
                                        </div>
                                        <div class="number-rating"><?php echo (esc_html(count($five_star)));?></div>
                                    </div>
                                    <div class="block-item-rating">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 4; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        </ul>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($four_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($four_star)/count($list_review):0);?>)">
                                            </div>
                                        </div>
                                        <div class="number-rating"><?php echo (esc_html(count($four_star)));?></div>
                                    </div>
                                    <div class="block-item-rating">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 3; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for($i = 1; $i <= 2; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($three_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($three_star)/count($list_review):0);?>)">
                                            </div>
                                        </div>
                                        <div class="number-rating"><?php echo (esc_html(count($three_star)));?></div>
                                    </div>
                                    <div class="block-item-rating">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 2; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for($i = 1; $i <= 3; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($two_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($two_star)/count($list_review):0);?>)">
                                            </div>
                                        </div>
                                        <div class="number-rating"><?php echo (esc_html(count($two_star)));?></div>
                                    </div>
                                    <div class="block-item-rating">
                                        <ul class="list-rating-star">
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php for($i = 1; $i <= 4; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($one_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($one_star)/count($list_review):0);?>)">
                                            </div>
                                        </div>
                                        <div class="number-rating"><?php echo (esc_html(count($one_star)));?></div>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-7">
                                <form action="" method="post" name="form-review">
                                    <div class="title-review">
                                        <h4><?php esc_html_e('Your Reviews','wpbookingpro');?></h4>
                                    </div>
                                    <div class="block-rating-star">
                                        <?php
                                        $field = $this->form_review->getField('rating');
                                        echo ($field->input);
                                        ?>
                                    </div>
                                    <div class="input-review">
                                        <div class="row row-form-review">
                                            <div class="col-md-12">
                                                <div class="block-name">
                                                    <?php
                                                    $field = $this->form_review->getField('name');
                                                    echo ($field->input);
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row row-form-review">
                                            <div class="col-md-12">
                                                <div class="block-email">
                                                    <?php
                                                    $field = $this->form_review->getField('email');
                                                    echo ($field->input);
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row row-form-review">
                                            <div class="col-md-12">
                                                <div class="block-title">
                                                    <?php
                                                    $field = $this->form_review->getField('title');
                                                    echo($field->input);
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row row-form-review">
                                            <div class="col-md-12">
                                                <div class="block-comment">
                                                    <?php
                                                    $field = $this->form_review->getField('comments');
                                                    echo ($field->input);
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="btn-submit">
                                                <button type="button" class="btn btn-primary btn-save-review"><?php esc_html_e('Submit','wpbookingpro');?></button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php echo ($this->form_review->renderField('id')) ?>
                                    <input type="hidden" name="task" value="review.save_review">
                                    <input type="hidden" name="link_redirect" value="<?php echo (esc_attr(Route::_($this->page_service_detail.'?service_id='.$this->item->id)));?>">
                                    <input type="hidden" name="service_id" value="<?php echo (esc_attr($this->item->id));?>">
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="block-review-by-customer">
                        <div class="title-review">
                            <h4> <?php esc_html_e('Reviews by customer','wpbookingpro');?> </h4>
                            <div class="line"></div>
                        </div>

                        <form action="" method="post" name="form-list-review-service">
                            <div class="wrapper-list-review">
                                <?php if (!empty($list_review)) {?>
                                    <?php foreach ($list_review as $review_item) {?>
                                        <div class="block-review-item">
                                            <div class="img-block">
                                                <div>
                                                    <img src="<?php echo (FactoryAlias::getRootUrlPlugin())?>frontend/app/assets/images/avatar-reviewer.jpg" alt="avatar-reviewer">
                                                </div>
                                            </div>
                                            <div class="block-content">
                                                <h5><?php echo (esc_html(isset($review_item->name)?$review_item->name:''))?></h5>
                                                <ul class="list-rating-star">
                                                    <?php $list_star_sum_review = HtmlFrontend::get_rating_star($review_item->avg_rating);?>
                                                    <?php for ($i=0; $i < $list_star_sum_review[0]; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                    <?php for ($i=0; $i < $list_star_sum_review[1]; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                    <?php }?>
                                                    <?php for ($i=0; $i < $list_star_sum_review[2]; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                </ul>
                                                <p><?php echo (esc_html(isset($review_item->comments)?$review_item->comments:''))?></p>
                                            </div>
                                            <div class="block-time-review">
                                                <h6><?php esc_html_e('Visited', 'wpbookingpro');?> <?php echo (esc_html(date('F d, Y',strtotime($review_item->created_date))))?></h6>
                                            </div>
                                        </div>
                                    <?php }?>
                                <?php }?>
                            </div>
                            <ul class="pagination-review"></ul>
                            <input type="hidden" name="limit" value="<?php echo (esc_attr($limit)) ?>">
                            <input type="hidden" name="start">
                        </form>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="block-rating-service">
                        <div class="row">
                            <div class="col-xs-5 col-sm-5 col-md-5">
                                <div class="block-rating-left">
                                    <h6><?php esc_attr_e('Venue rating','wpbookingpro')?></h6>
                                    <p>
                                        <?php
                                        if($rating_avg > 0) {
                                            esc_html_e(round($rating_avg,1));
                                        } else {
                                            echo (esc_html(0));
                                        }

                                        ?>
                                    </p>
                                    <div class="block-rating">
                                        <ul class="list-rating-star">
                                            <?php if ($rating_avg > 0) {?>
                                                <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php } else {?>
                                                <?php for ($i = 0; $i < 5; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }?>
                                        </ul>
                                        <div class="rating-review">
                                            <span><?php echo (esc_html(count($list_review)))?> <?php esc_attr_e('reviews','wpbookingpro');?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-7 col-sm-7 col-md-7">
                                <div class="block-rating-right">
                                    <div class="item-rating">
                                        <p><?php esc_attr_e('Ambience','wpbookingpro')?></p>
                                        <ul class="list-rating-star">
                                            <?php if($rating_ambience > 0) {?>
                                                <?php for ($i=0; $i <$list_star_ambience[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_ambience[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_ambience[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php } else {?>
                                                <?php for ($i = 0; $i < 5; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }?>
                                        </ul>
                                    </div>
                                    <div class="item-rating">
                                        <p><?php esc_attr_e('Cleanliness','wpbookingpro')?></p>
                                        <ul class="list-rating-star">
                                            <?php if ($rating_cleanliness > 0) {?>
                                                <?php for ($i=0; $i <$list_star_cleanliness[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_cleanliness[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_cleanliness[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php } else {?>
                                                <?php for ($i = 0; $i < 5; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }?>
                                        </ul>
                                    </div>
                                    <div class="item-rating">
                                        <p><?php esc_attr_e('Staff','wpbookingpro')?></p>
                                        <ul class="list-rating-star">
                                            <?php if ($rating_staff > 0) {?>
                                                <?php for ($i=0; $i <$list_star_staff[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_staff[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_staff[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php } else {?>
                                                <?php for ($i = 0; $i < 5; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }?>
                                        </ul>
                                    </div>
                                    <div class="item-rating">
                                        <p><?php esc_attr_e('Value','wpbookingpro')?></p>
                                        <ul class="list-rating-star">
                                            <?php if ($rating_value > 0) { ?>
                                                <?php for ($i=0; $i <$list_star_value[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_value[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_value[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }else {?>
                                                <?php for ($i = 0; $i < 5; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            <?php }?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="block-location-info">
                        <div class="map-block">
                            <?php echo(isset($this->item->location->iframe) ?html_entity_decode($this->item->location->iframe): '');?>
                        </div>
                        <h5><?php echo(isset($this->item->location->name)?$this->item->location->name:'');?></h5>
                        <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                        <div class="block-social-icon">
                            <a class="item-social" href="<?php echo('http://www.facebook.com/sharer.php?u='.$this->item->params->get('facebook')) ?>">
                                <i class="icon-nb-facebook"></i>
                            </a>
                            <a class="item-social" href="<?php echo(isset($this->item->mobile)?'tel:'.$this->item->mobile:'#');?>">
                                <i class="icon-nb-phone-call"></i>
                            </a>
                            <a class="item-social" href="<?php echo($this->item->params->get('instagram')) ?>">
                                <i class="icon-nb-instagram"></i>
                            </a>
                        </div>
                    </div>
                    <div class="block-info-working-time">
                        <?php if(count((array)$working_day)) {?>
                            <?php foreach ($working_day as $day) {?>
                                <div class="work-time-item">
                                    <span><?php esc_attr_e($day)?></span>
                                    <span><?php esc_html_e($open_time);?> - <?php esc_html_e($close_time);?></span>
                                </div>
                            <?php }?>
                        <?php }?>
                    </div>
                    <?php if(isset($this->item->user_id) && $this->item->user_id > 0 || isset($this->item->category) && $this->item->category->user_id > 0) {?>
                        <div class="block-info-vendor">
                            <div class="title">
                                <h3><?php esc_html_e('Added By', 'wpbookingpro');?></h3>
                                <div class="border-left"></div>
                            </div>
                            <div class="info-vendor">
                                <div class="avatar-name">
                                    <div class="vendor-image">
                                        <div>
                                            <img src="<?php echo (esc_url(isset($this->item->vendor->image)?$this->item->vendor->image:''))?>" alt="vendor-avatar">
                                        </div>
                                    </div>
                                    <div class="vendor-content">
                                        <h4><?php echo (esc_html(isset($this->item->vendor->first_name) || isset($this->item->vendor->last_name) ? Utility::get_full_name($this->item->vendor->first_name,$this->item->vendor->last_name):''))?></h4>
                                        <p><?php esc_html_e('Vendor','wpbookingpro');?></p>
                                    </div>
                                </div>
                                <div class="address-phone">
                                    <p class="vendor-address address-phone-item">
                                        <i class="icon-nb-pin"></i>
                                        <?php echo (esc_html(isset($this->item->vendor->address)?$this->item->vendor->address:''))?>
                                    </p>
                                    <p class="vendor-phone address-phone-item">
                                        <i class="icon-nb-phone-call"></i>
                                        <?php
                                        $mobile = isset($this->item->vendor->mobile)?$this->item->vendor->mobile:'';
                                        if(trim($mobile) != '' && $mobile['0'] == 0) {
                                            $mobile = substr($mobile,1);
                                        }
                                        $phonecode = isset($this->item->vendor->phonecode)?$this->item->vendor->phonecode:'';
                                        echo (esc_html('+'.$phonecode .' '. $mobile));
                                        ?>
                                    </p>
                                </div>
                                <div class="description">
                                    <?php echo (esc_html(isset($this->item->vendor->description)?$this->item->vendor->description:''))?>
                                </div>
                                <a href="<?php echo (esc_url($this->page_vendor_detail.'?user_id='.$this->item->user_id))?>" class="btn-view-detail"><?php esc_html_e('View more','wpbookingpro');?></a>
                            </div>
                        </div>
                    <?php }?>
                </div>
            </div>
        <?php } else {?>
            <div class="row">
                <div class="col-md-12 text-center">
                    <h3 class="heading-not-found"><?php esc_html_e('Can not found service','wpbookingpro');?></h3>
                    <a class="btn btn-primary btn-back-to-service-list" href="<?php esc_html_e($this->page_list_service);?>"><?php esc_html_e('Click here to back list service','wpbookingpro');?></a>
                </div>
            </div>
        <?php }?>
    </div>