<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;

$page_service_detail= ConfigHelper::get_page_service_detail();
if($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
}else{
    $this->page_service_detail="";
}

$list_service_wishlist = $this->list_service_wishlist;

?>

<div class="wrapper-wish-list">
    <h2><?php esc_html_e('Wishlist','wpbookingpro');?></h2>
    <table id="wish-list">
        <thead>
        <tr>
            <th><?php esc_html_e('Service','wpbookingpro');?></th>
            <th><?php esc_html_e('Image','wpbookingpro');?></th>
            <th><?php esc_html_e('Category','wpbookingpro');?></th>
            <th><?php esc_html_e('Price','wpbookingpro');?></th>
            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
        </tr>
        </thead>
        <tbody>
            <?php foreach ($list_service_wishlist as $service_wishlist) {?>
                <tr>
                    <td><?php echo (esc_html($service_wishlist->name))?></td>
                    <td class="service-image">
                        <div class="img-block">
                            <div>
                                <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().$service_wishlist->image))?>" alt="<?php echo (esc_attr($service_wishlist->name))?>">
                            </div>
                        </div>
                    </td>
                    <td><?php echo (esc_html($service_wishlist->category_name))?></td>
                    <td><?php echo (esc_html(FrontendHelper::format_currency($service_wishlist->price)))?></td>
                    <td>
                        <a class="btn-view" href="<?php echo (esc_url($this->page_service_detail.'?service_id='.$service_wishlist->id)) ?>">
                            <?php esc_html_e('View','wpbookingpro');?>
                        </a>
                    </td>
                </tr>
            <?php }?>
        </tbody>
    </table>
</div>
