<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\HtmlCustomField\HtmlCustomFieldFrontend;


$review_item = $this->review_item;

?>
<div class="wrapper-review-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Review Form','wpbookingpro');?></h2>
        <ul class="state-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                    <?php esc_html_e('Review detail', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">

                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_review->setValue('name',null, isset($review_item->name)?$review_item->name:'');
                        echo($this->form_review->renderField('name'))
                        ?>
                    </div>
                    <div class="col-md-12">
                        <?php
                        $this->form_review->setValue('email',null, isset($review_item->email)?$review_item->email:'');
                        echo($this->form_review->renderField('email'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_review->setValue('title',null, isset($review_item->title)?$review_item->title:'');
                        echo($this->form_review->renderField('title'))
                        ?>
                    </div>
                </div>
                <?php if(!$review_item->rating_vendor || $review_item->rating_vendor == 0) {?>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_review->setValue('rating_ambience',null, isset($review_item->rating_ambience)?$review_item->rating_ambience:'');
                        echo($this->form_review->renderField('rating_ambience'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_review->setValue('rating_cleanliness',null, isset($review_item->rating_cleanliness)?$review_item->rating_cleanliness:'');
                        echo($this->form_review->renderField('rating_cleanliness'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_review->setValue('rating_staff',null, isset($review_item->rating_staff)?$review_item->rating_staff:'');
                        echo($this->form_review->renderField('rating_staff'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_review->setValue('rating_value',null, isset($review_item->rating_value)?$review_item->rating_value:'');
                        echo($this->form_review->renderField('rating_value'))
                        ?>
                    </div>
                </div>
                <?php } else {?>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $this->form_review->setValue('rating_vendor_number',null, isset($review_item->rating_vendor)?$review_item->rating_vendor:'');
                            echo($this->form_review->renderField('rating_vendor_number'))
                            ?>
                        </div>
                    </div>
                <?php } ?>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_review->getField('published');
                        $field->setValue(isset($review_item->published)?$review_item->published:0);
                        echo($field->input);
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_review->setValue('comments',null, isset($review_item->comments)?$review_item->comments:'');
                        echo($this->form_review->renderField('comments'))
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-review'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-review" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>
    <input type="hidden" name="page_my_review" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-review'))?>">
    <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
</div>

