<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$order = $this->order;
$customer = $order->customer[0];
$list_rate  = reset($order->list_rate);
$user = $this->user;
$rate_order = isset($order->list_rate)?reset($order->list_rate):array();
$day_recurring = isset($order->order_day_recurring)?$order->order_day_recurring:array();

$orderstatusModel= Model::getInstance('orderstatuss');
$list_order_status=$orderstatusModel->getList();

?>
<div class="wrapper-order-detail">
    <h2><?php esc_html_e('Order detail','wpbookingpro');?></h2>
    <div class="block-order-detail">
        <div class="title">
            <span>#<?php echo (esc_html($order->id)) ?></span>
            <span><?php echo (esc_html(date('F d, Y',strtotime($order->created_date))))?></span>
        </div>
        <div class="status"><?php echo (esc_html($order->status_payment))?></div>
        <div class="block-order-detail-sum">
            <div class="content-top">
                <h3><?php echo (esc_html($list_rate->service_name))?></h3>
                <div class="price">
                    <i class="fas fa-tag"></i>
                    <span><?php echo (esc_html(HtmlFrontend::render_price($list_rate->price)))?></span>
                </div>
            </div>
            <div class="content-info-production">
                <table class="table table-striped table-info-order">
                    <tbody>
                    <tr>
                        <td><?php esc_html_e('Customer','wpbookingpro');?></td>
                        <td><?php echo (esc_html($order->customer_full_name));?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Customer phone','wpbookingpro');?></td>
                        <td>
                            <?php
                            $mobile = isset($customer->mobile)?$customer->mobile:'';
                            if($mobile['0'] == 0) {
                                $mobile = substr($mobile,1);
                            }
                            $phonecode = isset($customer->phonecode)?$customer->phonecode:'';
                            echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Customer email','wpbookingpro');?></td>
                        <td><?php echo (esc_html($customer->email));?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Employee','wpbookingpro');?></td>
                        <td><?php echo (esc_html($rate_order->employee_fullname));?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Location','wpbookingpro');?></td>
                        <td><?php echo (esc_html($list_rate->location_address))?></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Duration','wpbookingpro');?></td>
                        <td><?php echo (esc_html($list_rate->duration))?></td>
                    </tr>
                    <?php if($this->order->is_recurring == 0) {?>
                        <tr>
                            <td><?php esc_html_e('Date','wpbookingpro');?></td>
                            <td><?php echo (esc_html(HtmlFrontend::render_date($rate_order->start_date,'Y-m-d')));?></td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e('Time','wpbookingpro');?></td>
                            <td>
                                <?php echo (esc_html(HtmlFrontend::render_date($rate_order->start_date,'H:i A')));?> --
                                <?php echo (esc_html(HtmlFrontend::render_date($rate_order->end_date,'H:i A')));?>
                            </td>
                        </tr>
                    <?php } else {?>
                        <tr>
                            <td><?php esc_html_e('Date','wpbookingpro');?></td>
                            <td>
                                <?php echo (esc_html($rate_order->date_start_recurring));?> --
                                <?php echo (esc_html($rate_order->date_end_recurring));?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?php esc_html_e('Time','wpbookingpro');?>
                            </td>
                            <td>
                                <?php echo (esc_html($rate_order->time_start_recurring))?> --
                                <?php echo (esc_html($rate_order->time_end_recurring))?>
                            </td>
                        </tr>
                        <?php if($this->order->type_recurring == 'weekly' || $this->order->type_recurring == 'monthly') {?>
                            <tr>
                                <td>
                                    <?php esc_html_e('Day recurring','wpbookingpro');?>
                                </td>
                                <td>
                                    <?php echo (implode(', ', array_map(
                                        function ($v) {
                                            return ucfirst($v);
                                        }, $day_recurring
                                    ))); ?>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                    <?php if ($user->data->user_plugin->group_user_alias == 'vendor' && $user->data->user_plugin->id == $order->vendor_id) {?>
                        <tr class="change-order-status" data-order_id="<?php echo (esc_attr($order->id))?>">
                            <td><?php esc_html_e('Change order status','wpbookingpro');?></td>
                            <td>
                                <select class="orderstatus" name="open_source_order_status_id">
                                    <?php foreach ($list_order_status as $item){ ?>
                                        <option <?php echo ($item->open_source_order_status_id == $order->open_source_order_status_id ? 'selected':'') ?> value="<?php echo (esc_attr($item->open_source_order_status_id)); ?>">
                                            <?php echo (esc_html($item->name)); ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </td>
                        </tr>
                    <?php }?>

                    </tbody>
                </table>
            </div>
            <div class="content-info-payment">
                <div class="content-info-payment-item subtotal">
                    <span><?php esc_html_e('Subtotal:','wpbookingpro');?></span>
                    <span><?php echo (esc_html(HtmlFrontend::render_price($list_rate->subtotal)))?></span>
                </div>
                <div class="content-info-payment-item payment-method">
                    <span><?php esc_html_e('Payment method:','wpbookingpro');?></span>
                    <span><?php echo (esc_html(ucfirst($order->open_source_payment_id)))?></span>
                </div>
                <div class="content-info-payment-item total">
                    <span><?php esc_html_e('Total:','wpbookingpro');?></span>
                    <span><?php echo (esc_html(HtmlFrontend::render_price($list_rate->total)))?></span>
                </div>
            </div>
        </div>
    </div>
</div>
