<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;

$doc = Factory::getDocument();
$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}

$list_service = $this->list_service;

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>

<div class="wrapper-table-service">
    <h2><?php esc_html_e('My Services','wpbookingpro');?></h2>
    <div class="btn-add">
        <a href="<?php echo (esc_url($this->page_user_account . '?layout=my-service&form=service_form')) ?>"
           type="submit" class="btn btn-primary">
            <i class="icon-nb-plus"></i>
            <?php esc_html_e('Add New Service','wpbookingpro');?>
        </a>
    </div>
    <table id="list-service">
        <thead>
        <tr>
            <th><?php esc_html_e('Service','wpbookingpro');?></th>
            <th><?php esc_html_e('Image','wpbookingpro');?></th>
            <th><?php esc_html_e('Category','wpbookingpro');?></th>
            <th><?php esc_html_e('Price','wpbookingpro');?></th>
            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
        </tr>
        </thead>
        <tbody>
            <?php foreach ($list_service as $service){?>
                <tr data-service_id="<?php echo(esc_attr($service->id)) ?>">
                    <td>#<?php echo (esc_html($service->name))?></td>
                    <td class="service-image">
                        <div class="img-block">
                            <div>
                                <?php if($check_user_demo['is_demo']) {?>
                                    <img src="<?php echo(esc_url($uploads['baseurl'].'/' . $service->image)) ?>" alt="service_image">
                                <?php } else {?>
                                    <img src="<?php echo(esc_url(Factory::getRootUrlPlugin() . $service->image)) ?>" alt="service_image">
                                <?php } ?>
                            </div>
                        </div>
                    </td>
                    <td><?php echo (esc_html($service->category_name))?></td>
                    <td><?php echo (esc_html($service->price))?></td>
                    <td>
                        <div class="button-action">
                            <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-service&form=service_form&id='.$service->id)) ?>">
                                <i class="icon-nb-edit"></i>
                            </a>
                            <button  type="button" class="btn-delete btn-delete-service" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                <i class="icon-nb-delete"></i>
                            </button>
                        </div>
                    </td>
                </tr>
    <?php } ?>
        </tbody>
    </table>
    <input type="hidden" name="service_id">
    <input type="hidden" name="link_my_service" value="<?php echo(esc_attr($this->page_user_account . '?layout=my-service')) ?>">
</div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>