<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_review_vendor = $this->list_review_vendor;
$list_review_service = $this->list_review_service;
?>
<div class="wrapper-table-review">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('My reviews','wpbookingpro');?></h2>
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#vendor" aria-controls="vendor" role="tab" data-toggle="tab">
                    <?php esc_html_e('Vendor', 'wpbookingpro') ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#service" aria-controls="service" role="tab" data-toggle="tab">
                    <?php esc_html_e('Service', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>

    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="vendor">
                <table id="list-review-vendor">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('ID','wpbookingpro');?></th>
                        <th><?php esc_html_e('Reviewer','wpbookingpro');?></th>
                        <th><?php esc_html_e('Email','wpbookingpro');?></th>
                        <th><?php esc_html_e('Rating','wpbookingpro');?></th>
                        <th><?php esc_html_e('Comment','wpbookingpro');?></th>
                        <th><?php esc_html_e('Actions','wpbookingpro');?></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($list_review_vendor as $review_vendor) {?>
                            <tr data-review_id="<?php echo (esc_attr(isset($review_vendor->id)?$review_vendor->id:''))?>">
                                <td>#<?php echo (esc_html(isset($review_vendor->id)?$review_vendor->id:''))?></td>
                                <td> <?php echo (esc_html(isset($review_vendor->name)?$review_vendor->name:''))?> </td>
                                <td> <?php echo (esc_html(isset($review_vendor->email)?$review_vendor->email:''))?></td>
                                <td> <?php echo (esc_html(isset($review_vendor->rating_vendor)?$review_vendor->rating_vendor:''))?></td>
                                <td class="comments"><span><?php echo (esc_html(isset($review_vendor->comments)?$review_vendor->comments:''))?></span></td>
                                <td>
                                    <div class="button-action">
                                        <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-review&form=review_form&id='.$review_vendor->id)) ?>">
                                            <i class="icon-nb-edit"></i>
                                        </a>
                                        <button  type="button" class="btn-delete btn-delete-review-vendor" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                            <i class="icon-nb-delete"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <div role="tabpanel" class="tab-pane" id="service">
                <table id="list-review-service">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('ID','wpbookingpro');?></th>
                        <th><?php esc_html_e('Reviewer','wpbookingpro');?></th>
                        <th><?php esc_html_e('Email','wpbookingpro');?></th>
                        <th><?php esc_html_e('Rating','wpbookingpro');?></th>
                        <th><?php esc_html_e('Comment','wpbookingpro');?></th>
                        <th><?php esc_html_e('Actions','wpbookingpro');?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($list_review_service as $review_service) {?>
                        <tr data-review_id="<?php echo (esc_attr(isset($review_service->id)?$review_service->id:''))?>">
                            <td>#<?php echo (esc_html(isset($review_service->id)?$review_service->id:''))?></td>
                            <td> <?php echo (esc_html(isset($review_service->name)?$review_service->name:''))?> </td>
                            <td> <?php echo (esc_html(isset($review_service->email)?$review_service->email:''))?></td>
                            <td> <?php echo (esc_html(isset($review_service->avg_rating)?$review_service->avg_rating:''))?></td>
                            <td class="comments"><span><?php echo (esc_html(isset($review_service->comments)?$review_service->comments:''))?></span></td>
                            <td>
                                <div class="button-action">
                                    <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-review&form=review_form&id='.$review_service->id)) ?>">
                                        <i class="icon-nb-edit"></i>
                                    </a>
                                    <button  type="button" class="btn-delete btn-delete-review-service" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                        <i class="icon-nb-delete"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <input type="hidden" name="review_id">
    <input type="hidden" name="page_my_review" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-review'))?>">
</div>
