<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();

$list_location = $this->list_location;
?>
<div class="wrapper-table-location">
    <h2><?php esc_html_e('My locations','wpbookingpro');?></h2>
    <div class="btn-add">
        <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-location&form=location_form')) ?>" class="btn btn-primary">
            <i class="icon-nb-plus"></i>
            <?php esc_html_e('Add New Location','wpbookingpro');?>
        </a>
    </div>
    <table id="list-location">
        <thead>
        <tr>
            <th><?php esc_html_e('ID','wpbookingpro');?></th>
            <th><?php esc_html_e('Name','wpbookingpro');?></th>
            <th><?php esc_html_e('State - Country','wpbookingpro');?></th>
            <th><?php esc_html_e('Published','wpbookingpro');?></th>
            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
        </tr>
        </thead>
        <tbody>
            <?php foreach ($list_location as $location) {?>
                <tr data-location_id="<?php echo (esc_attr(isset($location->id)?$location->id:'')) ?>">
                    <td>#<?php echo (esc_html(isset($location->id)?$location->id:'')) ?></td>
                    <td><?php echo (esc_html(isset($location->name)?$location->name:'')) ?></td>
                    <td><?php echo (esc_html(isset($location->state_name) && isset($location->country_name)?$location->state_name.' - '.$location->country_name:'')) ?></td>
                    <td>
                        <?php if ($location->published == 1) { ?>
                            <div class="published">
                                <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                            </div>
                        <?php } else { ?>
                            <div class="unpublished">
                                <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                            </div>
                        <?php } ?>
                    </td>
                    <td>
                        <div class="button-action">
                            <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-location&form=location_form&id='.$location->id)) ?>">
                                <i class="icon-nb-edit"></i>
                            </a>
                            <button  type="button" class="btn-delete btn-delete-location" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                <i class="icon-nb-delete"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
    <input type="hidden" name="location_id">
    <input type="hidden" name="page_my_location" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-location'))?>">
</div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>