<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();

$list_employee = $this->list_employee;

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
    <div class="wrapper-table-employee">
        <h2><?php esc_html_e('My Employees', 'wpbookingpro'); ?></h2>
        <div class="btn-add">
            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-employee&form=employee_form')) ?>"
               type="submit" class="btn btn-primary">
                <i class="icon-nb-plus"></i>
                <?php esc_html_e('Add New Employee','wpbookingpro');?>
            </a>
        </div>
        <table id="list-employee">
            <thead>
            <tr>
                <th><?php esc_html_e('Name', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Image', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Email', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Phone', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Actions', 'wpbookingpro'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($list_employee as $employee) { ?>
                <tr data-employee_id="<?php echo(esc_attr($employee->id)) ?>">
                    <td><?php echo (esc_html(Utility::get_full_name($employee->first_name,$employee->last_name)))?></td>
                    <td class="employee-image">
                        <div class="img-block">
                            <div>
                                <?php if($check_user_demo['is_demo']) {?>
                                    <img src="<?php echo(esc_url($uploads['baseurl'].'/' . $employee->image)) ?>" alt="employee_image">
                                <?php } else {?>
                                    <img src="<?php echo(esc_url(Factory::getRootUrlPlugin() . $employee->image)) ?>" alt="employee_image">
                                <?php } ?>
                            </div>
                        </div>
                    </td>
                    <td><?php echo (esc_html($employee->email))?></td>
                    <td>
                        <?php
                        $mobile = isset($employee->mobile)?$employee->mobile:'';
                        if($mobile['0'] == 0) {
                            $mobile = substr($mobile,1);
                        }
                        $phonecode = isset($employee->phonecode)?$employee->phonecode:'';
                        echo (esc_html('+'.$phonecode .' '. $mobile));
                        ?>
                    </td>
                    <td>
                        <div class="button-action">
                            <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-employee&form=employee_form&id='.$employee->id)) ?>">
                                <i class="icon-nb-edit"></i>
                            </a>
                            <button  type="button" class="btn-delete btn-delete-employee" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                <i class="icon-nb-delete"></i>
                            </button>
                        </div>
                    </td>
                </tr>

            <?php } ?>
            </tbody>
        </table>
        <input type="hidden" name="employee_id">
        <input type="hidden" name="link_my_employee" value="<?php echo(esc_attr($this->page_user_account . '?layout=my-employee')) ?>">
    </div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>