<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();
$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_customers = $this->list_customers;
?>
<div class="wrapper-table-customer">
    <h2><?php esc_html_e('My customers','wpbookingpro');?></h2>
    <table id="list-customer">
        <thead>
        <tr>
            <th><?php esc_html_e('ID','wpbookingpro');?></th>
            <th><?php esc_html_e('Name','wpbookingpro');?></th>
            <th><?php esc_html_e('Phone','wpbookingpro');?></th>
            <th><?php esc_html_e('Gender','wpbookingpro');?></th>
            <th><?php esc_html_e('Birthday','wpbookingpro');?></th>
            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($list_customers as $customer) {?>
            <tr data-customer_id="<?php echo (esc_attr(isset($customer->id)?$customer->id:'')) ?>">
                <td>#<?php echo (esc_attr(isset($customer->id)?$customer->id:'')) ?></td>
                <td><?php echo (esc_attr(isset($customer->first_name) || isset($customer->last_name)?Utility::get_full_name($customer->first_name, $customer->last_name):'')) ?></td>
                <td>
                    <?php
                    $mobile = isset($customer->mobile)?$customer->mobile:'';
                    if($mobile['0'] == 0) {
                        $mobile = substr($mobile,1);
                    }
                    $phonecode = isset($customer->phonecode)?$customer->phonecode:'';
                    echo (esc_html('+'.$phonecode .' '. $mobile));
                    ?>
                </td>
                <td><?php echo (esc_attr(isset($customer->gender)?$customer->gender:'')) ?></td>
                <td><?php echo (esc_attr(isset($customer->birth_day)?$customer->birth_day:'')) ?></td>
                <td>
                    <div class="button-action">
                        <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-customer&form=customer_form&id='.$customer->id)) ?>">
                            <i class="icon-nb-edit"></i>
                        </a>
                        <button  type="button" class="btn-delete btn-delete-customer" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                            <i class="icon-nb-delete"></i>
                        </button>
                    </div>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
    <input type="hidden" name="customer_id">
    <input type="hidden" name="page_my_customer" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-customer'))?>">
</div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>