<?php

use WpBookingPro\Factory as FactoryAlias;

$location_item = $this->location_item;
?>
<div class="wrapper-location-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Location Form','wpbookingpro');?></h2>
        <ul class="room-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                    <?php esc_html_e('Details Location', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('name', null, isset($location_item->name)?$location_item->name:'');
                        echo ($this->form_location->renderField('name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('state_id', null, isset($location_item->state_id)?$location_item->state_id:'');
                        echo ($this->form_location->renderField('state_id'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('lat', null, isset($location_item->lat)?$location_item->lat:'');
                        echo ($this->form_location->renderField('lat'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('lang', null, isset($location_item->lang)?$location_item->lang:'');
                        echo ($this->form_location->renderField('lang'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('address', null, isset($location_item->address)?$location_item->address:'');
                        echo ($this->form_location->renderField('address'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_location->setValue('iframe', null, isset($location_item->iframe)?$location_item->iframe:'');
                        echo ($this->form_location->renderField('iframe'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo ($this->form_location->renderField('mobile')) ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $field = $this->form_location->getField('published');
                        $field->setValue(isset($location_item->published)?$location_item->published:0);
                        echo ($field->input)
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_location->setValue('description', null, isset($location_item->description)?$location_item->description:'');
                        echo ($this->form_location->renderField('description'))
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-location'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-location" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>

    </div>
    <input type="hidden" name="page_my_location" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-location'))?>">
    <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
</div>
