<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\HtmlCustomField\HtmlCustomFieldFrontend;
use WpBookingProFrontend\app\helpers\ConfigHelper;


$employee_item = $this->employee_item;



?>


<div class="wrapper-employee-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Employee Form','wpbookingpro');?></h2>
        <ul class="state-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#detail" aria-controls="detail" role="tab" data-toggle="tab">
                    <?php esc_html_e('Employee detail','wpbookingpro') ?>
                </a>
            </li>
            <li role="presentation" >
                <a href="#assign-service" aria-controls="assign-service" role="tab" data-toggle="tab">
                    <?php esc_html_e('Assign Service','wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="detail">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_employee->getField('image');
                        $field->setValue(isset($employee_item->image)?$employee_item->image:'');
                        echo($this->form_employee->renderField('image'))
                        ?>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('first_name',null, isset($employee_item->first_name)?$employee_item->first_name:'');
                        echo($this->form_employee->renderField('first_name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('last_name',null, isset($employee_item->last_name)?$employee_item->last_name:'');
                        echo($this->form_employee->renderField('last_name'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('email',null, isset($employee_item->email)?$employee_item->email:'');
                        echo($this->form_employee->renderField('email'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('location_id',null, isset($employee_item->location_id)?$employee_item->location_id:'');
                        echo($this->form_employee->renderField('location_id'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('facebook','params', isset($employee_item->params)?$employee_item->params->get('facebook'):'');
                        echo($this->form_employee->renderField('facebook','params'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_employee->setValue('instagram','params', isset($employee_item->params)?$employee_item->params->get('instagram'):'');
                        echo($this->form_employee->renderField('instagram','params'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $field=$this->form_employee->getField('published');
                        $field->setValue(isset($employee_item->published)?$employee_item->published:0)
                        ?>
                        <?php echo($field->input) ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo($this->form_employee->renderField('mobile')) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_employee->setValue('note_internal',null, isset($employee_item->note_internal)?$employee_item->note_internal:'');
                        echo($this->form_employee->renderField('note_internal'))
                        ?>
                    </div>
                </div>
            </div>
            <div role="tabpanel" class="tab-pane" id="assign-service">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_employee->getField('assign_service');
                        echo ($field->input);
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-employee'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-employee" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>
    <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
    <input type="hidden" name="link_redirect" value="<?php echo (esc_url($this->page_user_account.'?layout=my-employee'));?>">
</div>
