<?php

use WpBookingPro\Factory as FactoryAlias;

$customer_item = $this->customer_item;
?>
<div class="wrapper-customer-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Customer Form','wpbookingpro');?></h2>
        <ul class="room-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                    <?php esc_html_e('Customer details', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_customer->getField('image');
                        $field->setValue(isset($customer_item->image)?$customer_item->image:'');
                        echo($field->input);
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('first_name', null, isset($customer_item->first_name)?$customer_item->first_name:'');
                        echo($this->form_customer->renderField('first_name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('last_name', null, isset($customer_item->last_name)?$customer_item->last_name:'');
                        echo($this->form_customer->renderField('last_name'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('email', null, isset($customer_item->email)?$customer_item->email:'');
                        echo($this->form_customer->renderField('email'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('opensource_user_id', null, isset($customer_item->opensource_user_id)?$customer_item->opensource_user_id:'');
                        echo($this->form_customer->renderField('opensource_user_id'))
                        ?>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo($this->form_customer->renderField('mobile')) ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo($this->form_customer->renderField('gender')) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('birth_day', null, isset($customer_item->birth_day)?$customer_item->birth_day:'');
                        echo($this->form_customer->renderField('birth_day'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('city', null, isset($customer_item->city)?$customer_item->city:'');
                        echo($this->form_customer->renderField('city'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('address_1', null, isset($customer_item->address_1)?$customer_item->address_1:'');
                        echo($this->form_customer->renderField('address_1'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_customer->setValue('address_2', null, isset($customer_item->address_2)?$customer_item->address_2:'');
                        echo($this->form_customer->renderField('address_2'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_customer->setValue('note_internal', null, isset($customer_item->note_internal)?$customer_item->note_internal:'');
                        echo($this->form_customer->renderField('note_internal'))
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-customer'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-customer" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>
    <input type="hidden" name="page_my_customer" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-customer'))?>">
    <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
</div>
