<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class WishlistModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "wishlist";
    /**
     * @var string
     */
    public $table_name = "wishlist";

    public function saveUserWishlist($data = array()) {
        $service_id = isset($data['service_id']) ? sanitize_text_field($data['service_id']) : '';
        $user_id = isset($data['user_id']) ? sanitize_text_field($data['user_id']) : '';
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->delete($this->getTableName('wishlist'))
            ->where('service_id='.(int)$service_id)
            ->where('user_id='.(int)$user_id)
        ;
        $db->setQuery($query)->execute();

        $query->clear()
            ->insert($this->getTableName('wishlist'))
            ->set('service_id='.(int)$service_id)
            ->set('user_id='.(int)$user_id)
        ;
        $db->setQuery($query)->execute();
    }

    public function deleteUserWishlist($data = array()) {
        $service_id = isset($data['service_id'])?$data['service_id']:'';
        $user_id = isset($data['user_id'])?$data['user_id']:'';
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->delete($this->getTableName('wishlist'))
            ->where('service_id='.(int)$service_id)
            ->where('user_id='.(int)$user_id)
        ;
        $db->setQuery($query)->execute();
    }



}
