<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class SignupModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "signup";
    /**
     * @var string
     */
    public $table_name = "user";

    public function createUserAccount($data = array()) {
        if(!function_exists('wp_get_current_user')) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        $email = isset($data['email']) ? sanitize_text_field($data['email']) : '';
        $first_name = isset($data['first_name']) ? sanitize_text_field($data['first_name']) : '';
        $last_name = isset($data['last_name']) ? sanitize_text_field($data['last_name']) : '';
        $username = isset($data['user_name']) ? sanitize_text_field($data['user_name']) : '';
        $password = isset($data['password']) ? sanitize_text_field($data['password']) : '';
        $now = Factory::getDate();
        $appConfig = Factory::getAppConfig();
        $default_groupuser_signup = $appConfig->get('default_groupuser_signup', '');
        $user_id = wp_insert_user( array(
            'user_login' => $username,
            'user_pass' => $password,
            'user_email' => $email,
            'first_name' => $first_name,
            'last_name' => $last_name,
            'display_name' => Utility::get_full_name($first_name, $last_name),
            'role' => 'editor'
        ));
        $data_user = array(
            "first_name"=>$first_name,
            "last_name"=> $last_name,
            "email"=>$email,
            "created"=> $now->toSql(),
            "open_source_user_id"=> $user_id,
            "group_user_id"=>(int)$default_groupuser_signup
        );
        $modelUser = Model::getInstance('user');
        $modelUser->save($data_user);
        return $user_id;

    }



}
