<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Factory as FactoryAlias;

use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Router\Route;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

class ServicesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "services";
    /**
     * @var string
     */
    public $table_name = "service";
    public function getListQuery()
    {
        $input=FactoryAlias::getInput();
        $data=$input->getData();
        $location_id=$input->getInt('location',0);
        $price_search=$input->getString('price_search',"");
        $near_me = $input->getInt('near_me',0);
        $latitude = $input->getFloat('latitude','');
        $longitude = $input->getFloat('longitude','');
        $appConfig = FactoryAlias::getAppConfig();
        $radius_for_search = $appConfig->get('radius_for_search', '');
        $unit_for_search = $appConfig->get('unit_for_search', '');

        if($price_search!==""){
            $price_search=(array)json_decode($price_search);
        }

        $category='';
        if(array_key_exists('category',(array)$data)) {
            $category=$data['category'];
            if(!empty($category)){
                $category=(array)$category;
            }
        }
        $employee='';
        if(array_key_exists('employee',(array)$data)) {
            $employee=$data['employee'];
            if(!empty($employee)){
                $employee=(array)$employee;
            }
        }
        $vendor='';
        if(array_key_exists('vendor',(array)$data)) {
            $vendor=$data['vendor'];
            if(!empty($vendor)){
                $vendor=(array)$vendor;
            }
        }

        $query=$this->db->getQuery(true);
        $query->select("DISTINCT a.*")
            ->from($this->getTableName("service").' AS a')
            ->leftJoin($this->getTableName('category') . ' AS category ON category.id=a.category_id')
            ->select('category.name as category_name')
            ->leftJoin($this->getTableName('location') . ' AS location ON location.id=a.location_id')
            ->select('location.name as location_name')
            ->where('a.published=1')
        ;

        $keyword=$input->getString('keyword',"");
        if($keyword!==""){
            $query->where('a.name LIKE '.$query->quote("%$keyword%"));
        }
        $keyword_address = $input->getString('address','');
        if($keyword_address!==""){
            $query->where('location.name LIKE '.$query->quote("%$keyword_address%"));
        }

        if($location_id!=0){
            $query
                ->where('a.location_id='.(int)$location_id)
            ;
        }
        if($near_me == 1) {
            if($latitude != '' && $longitude != '') {
                $modelLocations = Model::getInstance('locations');
                $list_location = $modelLocations->getList();
                $query2= $this->_db->getQuery(true);

                foreach ($list_location as $location) {
                    $distance = static::getDistanceBetweenPointsNew($latitude, $longitude, $location->lat, $location->lang,$unit_for_search);
                    $query2->clear()
                        ->update($this->getTableName('service'). ' AS service')
                        ->set('service.distance='.(float)$distance)
                        ->where('service.location_id='.(int)$location->id)
                    ;
                    $this->db->setQuery($query2)->execute();
                }
                $query->where('a.distance <= '.(float)$radius_for_search);
            }
        }

        if(is_array($price_search) && !empty($price_search)){
            $min=reset($price_search);
            $max=end($price_search);

            $query->where('a.price>='.(float)$min);
            $query->where('a.price<='.(float)$max);
        }
        if(is_array($employee) && !empty($employee)){
            $query
                ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                ->where('service_employee.employee_id IN ('.implode($employee,",").')')
            ;
        } elseif(trim($employee) != '') {
            $query
                ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                ->where('service_employee.employee_id = '.(int)$employee)
            ;
        }
        if(is_array($vendor) && !empty($vendor)){
            $query
                ->where('a.user_id IN ('.implode(",", $vendor).')')
            ;
        } elseif(trim($vendor) != '') {
            $query
                ->where('a.user_id ='.(int)$vendor)
            ;
        }
        if(is_array($category) && !empty($category)){
            $query
                ->where('a.category_id IN ('.implode($category,",").')')
            ;
        } elseif(trim($category) != '') {
            $query
                ->where('a.category_id = '.(int)$category)
            ;
        }
        $key_sort_by="a.ordering";
        if(isset($data['sort']) && trim($data['sort'])!==''){
            $key_sort_by=$data['sort'];
        }
        $direction="";
        if(isset($data['direction']) && trim($data['direction'])!==''){
            $direction=$data['direction'];
        }
        $query->order("$key_sort_by $direction");
        $query->group('a.id');
        return $query;
    }
    public function getList()
    {
        $input = FactoryAlias::getInput();
        $limit = $input->getInt('limit', 1);
        $start = $input->getInt('start', 0);
        $total_result = $input->getInt('total_result', 0);
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query, $start * $limit, (($total_result - $start * $limit) > $limit)?$limit: ($total_result - $start * $limit))->loadObjectList();
        $input = FactoryAlias::getInput();
        $data = $input->getData();
        $rating = isset($data['rating'])?$data['rating']:array();
        if(is_array($rating) && count($rating)) {
            $rating = array_map(function ($v){
                return json_decode($v);
            },$rating);
            $rating = call_user_func_array("array_merge",$rating);
        }elseif(is_string($rating) && trim($rating) != '') {
            $rating = json_decode($rating);
        }

        foreach ($list_service as $key => &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
                ->where('review.published=1')
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();

            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $query->clear()
                ->select('wishlist.id')
                ->from($this->getTableName('wishlist').' AS wishlist')
                ->where('wishlist.service_id='.(int)$item->id)
                ->where('wishlist.user_id='.(int)$user_id)
            ;
            $wishlist = $this->_db->setQuery($query)->loadResult();
            $item->wishlist = $wishlist;


            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;
            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }
            if(!empty($rating)) {
                if($item->rating_avg < min($rating) || $item->rating_avg > max($rating)) {
                    unset($list_service[$key]);
                }
            }



            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
        }
        return $list_service;
    }

    public function getTotalServiceNoPagination() {
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        $input = FactoryAlias::getInput();
        $data = $input->getData();
        $rating = isset($data['rating'])?$data['rating']:array();
        if(is_array($rating) && count($rating)) {
            $rating = array_map(function ($v){
                return json_decode($v);
            },$rating);
            $rating = call_user_func_array("array_merge",$rating);
        } elseif(is_string($rating) && trim($rating) != '') {
            $rating = json_decode($rating);
        }
        foreach ($list_service as $key => &$item) {
            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
                ->where('review.published=1')
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();
            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;
            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }
            if(!empty($rating)) {
                if($item->rating_avg < min($rating) || $item->rating_avg > max($rating)) {
                    unset($list_service[$key]);
                }
            }
        }
        return count($list_service);
    }



    public function get_list_service_loc()
    {
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        $input = FactoryAlias::getInput();
        $data = $input->getData();
        $rating = isset($data['rating'])?$data['rating']:'';
        if(is_array($rating) && count($rating)) {
            $rating = array_map(function ($v){
                return json_decode($v);
            },$rating);
            $rating = call_user_func_array("array_merge",$rating);
        } else {
            $rating = json_decode($rating);
        }

        foreach ($list_service as $key => &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();
            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();
            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $query->clear()
                ->select('wishlist.id')
                ->from($this->getTableName('wishlist') . ' AS wishlist')
                ->where('wishlist.service_id=' . (int)$item->id)
                ->where('wishlist.user_id=' . (int)$user_id)
            ;
            $wishlist = $this->db->setQuery($query)->loadResult();
            $item->wishlist = $wishlist;

            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                ->where('service_review.service_id='.(int)$item->id)
            ;
            $list_review = $this->_db->setQuery($query)->loadObjectList();
            $arr_rating_avg = array();
            foreach ($list_review as $review) {
                $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                $rating_value = isset($review->rating_value)?$review->rating_value:0;
                $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                array_push($arr_rating_avg,$review->avg_rating);
            }
            $item->list_review = $list_review;
            if(!empty($arr_rating_avg)) {
                $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
            }else {
                $item->rating_avg = 0;
            }

            if(!empty($rating)) {
                if($item->rating_avg < min($rating) || $item->rating_avg > max($rating)) {
                    unset($list_service[$key]);
                }
            }


            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;

            $item->lang = isset(reset($location)->lang)?reset($location)->lang:0;
            $item->lat = isset(reset($location)->lat)?reset($location)->lat:0;
        }


        return array_values($list_service);
    }


    public static function getDistanceBetweenPointsNew($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Mi') {
        $theta = (float)$longitude1 - (float)$longitude2;
        $distance = sin(deg2rad((float)$latitude1)) * sin(deg2rad((float)$latitude2)) + cos(deg2rad((float)$latitude1)) * cos(deg2rad((float)$latitude2)) * cos(deg2rad((float)$theta));

        $distance = acos($distance);
        $distance = rad2deg($distance);
        $distance = $distance * 60 * 1.1515;

        switch($unit)
        {
            case 'Mi': break;
            case 'Km' : $distance = $distance * 1.609344;
        }

        return (round($distance,2));
    }

    public function renderServiceHtmlAjax() {
        include(ABSPATH . "wp-includes/pluggable.php");
        $result=[];
        $list_service = $this->getList();
        $input = FactoryAlias::getInput();
        $page_service_detail = $input->getString('page_service_detail','');
        $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
        $check_user_demo = FrontendHelper::checkUserDemo();
        $uploads = wp_upload_dir();
        ob_start();
        ?>
        <div id="grid-display" class="tab-pane fade in active">
            <div class="row">
                <?php foreach ($list_service as $service){ ?>
                    <?php
                    $rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
                    if($rating_avg > 0) {
                        $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
                    }
                    $list_review = isset($service->list_review)?$service->list_review:array();
                    $input = FactoryAlias::getInput();
                    $near_me=$input->getInt('near_me',0);
                    $appConfig = FactoryAlias::getAppConfig();
                    $unit_for_search = $appConfig->get('unit_for_search', '');
                    $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $service->image);
                    ?>
                    <div class="col-sm-6 col-md-4">
                        <div class="block-service-item" data-service_id="<?php echo (esc_attr($service->id))?>">
                            <div class="content-top">
                                <a href="<?php echo  (esc_url($page_service_detail.'?service_id='.$service->id)); ?>">
                                    <div class="block-img">
                                        <div>
                                            <?php if($check_user_demo['is_demo']) {?>
                                                <?php if($check_image_size) {?>
                                                    <img src="<?php echo (esc_url($uploads['baseurl'].'/'.$service->image));?>" alt="service">
                                                <?php } else {?>
                                                    <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$service->image));?>" alt="service">
                                                <?php } ?>

                                            <?php } else {?>
                                                <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$service->image));?>" alt="service">

                                            <?php } ?>
                                        </div>
                                    </div>
                                </a>
                                <div class="block-feature">
                                    <div class="label-feature <?php echo (esc_attr(isset($service->is_feature) && $service->is_feature==1 ? 'visible':''));?>">
                                        <span><?php esc_html_e('Featured','wpbookingpro');?></span>
                                    </div>
                                    <?php if($user_id != '') {?>
                                        <i class="fas fa-heart <?php echo (esc_attr(isset($service->wishlist)? 'active':''))?>"></i>
                                    <?php }?>
                                </div>
                            </div>
                            <div class="content-bottom">
                                <p class="place-service" title="<?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>">
                                    <i class="icon-nb-pin"></i>
                                    <?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>
                                </p>
                                <a href="<?php echo  (esc_url($page_service_detail.'?service_id='.$service->id)); ?>">
                                    <h4 class="name-service" title="<?php echo (esc_html(isset($service->name)?$service->name:''));?>">
                                        <?php echo (esc_html(isset($service->name)?$service->name:''));?>
                                    </h4>
                                </a>
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php if($rating_avg > 0) {?>
                                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php } else {?>
                                            <?php for ($i=0; $i < 5;$i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span><?php echo (esc_html(count($list_review)))?> <?php esc_html_e('reviews','wpbookingpro');?></span>
                                    </div>
                                </div>
                                <div class="block-trip-price">
                                    <div class="time-trip">
                                        <i class="icon-nb-clock"></i>
                                        <span><?php echo (esc_html(isset($service->duration)?$service->duration:''));?> <?php esc_html_e('hours','wpbookingpro');?></span>
                                    </div>
                                    <div class="price-service">
                                        <span><i class="fas fa-bolt"></i><span><?php esc_html_e('From','wpbookingpro');?></span></span>
                                        <span class="price"><?php echo (esc_html(FrontendHelper::format_currency(number_format((float)$service->price,2))));?></span>
                                    </div>
                                </div>
                                <?php if($near_me == 1) {?>
                                    <div class="distance-between-your-location">
                                        <i class="fas fa-map-pin"></i>
                                        <span>
                                            <?php echo (esc_html(isset($service->distance)?$service->distance:0))?>
                                            <?php
                                            if($unit_for_search == 'Km') {
                                                echo (esc_html('Km'));
                                            } elseif ($unit_for_search='Mi') {
                                                echo (esc_html('Mile'));
                                            }
                                            ?>
                                        </span>
                                    </div>
                                <?php }?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div id="list-display" class="tab-pane fade">
            <?php foreach ($list_service as $service){ ?>
                <?php
                $rating_avg=isset($service->rating_avg)?$service->rating_avg:0;
                if($rating_avg > 0) {
                    $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
                }
                $list_review = isset($service->list_review)?$service->list_review:array();
                $input = FactoryAlias::getInput();
                $near_me=$input->getInt('near_me',0);
                $appConfig = FactoryAlias::getAppConfig();
                $unit_for_search = $appConfig->get('unit_for_search', '');
                $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $service->image);
                ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="block-service-item-display-list" data-service_id="<?php echo (esc_attr($service->id))?>">
                            <div class="block-info-content">
                                <a href="<?php echo  (esc_url(Route::_($page_service_detail.'?service_id='.$service->id))); ?>">
                                    <div class="img-block">
                                        <div>
                                            <?php if($check_user_demo['is_demo']) {?>
                                                <?php if($check_image_size) {?>
                                                    <img src="<?php echo (esc_url($uploads['baseurl'].'/' .$service->image));?>" alt="service">
                                                <?php }else {?>
                                                    <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin() .$service->image));?>" alt="service">
                                                <?php }?>

                                            <?php }else {?>
                                                <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$service->image));?>" alt="service">
                                            <?php }?>
                                        </div>
                                    </div>
                                </a>
                                <div class="block-feature">
                                    <div class="label-feature <?php echo (esc_attr(isset($service->is_feature) && $service->is_feature == 1?'visible':''));?>">
                                        <span><?php esc_html_e('Featured','wpbookingpro');?></span>
                                    </div>
                                    <?php if($user_id != '') {?>
                                        <i class="fas fa-heart <?php echo (esc_attr(isset($service->wishlist)? 'active':'')) ?>"></i>
                                    <?php }?>
                                </div>
                            </div>
                            <div class="content-infor-service">
                                <p class="place-service">
                                    <i class="icon-nb-pin"></i>
                                    <span title="<?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>">
                                        <?php echo (esc_html(isset($service->location->address)?$service->location->address:''));?>
                                    </span>
                                </p>
                                <a href="<?php echo  (esc_url(Route::_($page_service_detail.'?service_id='.$service->id))) ; ?>">
                                    <h4 class="name-service" title="<?php echo (esc_html(isset($service->name)?$service->name:'')) ?>">
                                        <?php echo (esc_html(isset($service->name)?$service->name:''));?>
                                    </h4>
                                </a>
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php if($rating_avg > 0) {?>
                                            <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php } else {?>
                                            <?php for ($i=0; $i < 5;$i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span><?php echo (esc_html(count($list_review)))?> <?php esc_html_e('reviews','wpbookingpro');?></span>
                                    </div>
                                </div>
                                <div class="description">
                                    <?php echo (esc_html(isset($service->description)?$service->description:''));?>
                                </div>
                            </div>
                            <div class="content-right">
                                <div class="price-service">
                                    <p class="new-price">
                                        <span><i class="fas fa-bolt"></i><span><?php esc_html_e('from','wpbookingpro');?></span></span>
                                        <span class="price"><?php echo (esc_html(FrontendHelper::format_currency(number_format((float)$service->price,2))));?></span>
                                    </p>
                                </div>
                                <div class="trip-time">
                                    <i class="icon-nb-clock"></i>
                                    <span><?php echo (esc_html(isset($service->duration)?$service->duration:''));?> <?php esc_html_e('hours','wpbookingpro');?></span>
                                </div>
                                <?php if($near_me == 1) {?>
                                    <div class="distance-between-your-location">
                                        <i class="fas fa-map-pin"></i>
                                        <span>
                                            <?php echo (esc_html(isset($service->distance)?$service->distance:0))?>
                                            <?php
                                            if($unit_for_search == 'Km') {
                                                echo (esc_html('Km'));
                                            } elseif ($unit_for_search='Mi') {
                                                echo (esc_html('Mile'));
                                            }
                                            ?>
                                        </span>
                                    </div>
                                <?php }?>
                                <div class="view-more">
                                    <button type="button" class="btn btn-primary"><?php esc_attr_e('View service','wpbookingpro');?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php
        $content = ob_get_clean();
        $result['total_service'] = $this->getTotalServiceNoPagination();
        $result['html'] = $content;

        return $result;

    }

    public function getListServiceByUser(){
        if(is_user_logged_in()) {
            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $user = wp_get_current_user();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('user.id')
                ->from($this->getTableName('user') .' AS user')
                ->where('user.open_source_user_id   ='.(int)$user->ID)
            ;
            $user_id_plugin = $db->setQuery($query)->loadResult();
            $query->clear()
                ->select('*')
                ->from($this->getTableName('service'))
                ->where('user_id='.(int)$user_id_plugin)
            ;
            $list_service = $db->setQuery($query)->loadObjectList();
            foreach ($list_service as $service){
                $query->clear()
                    ->select('category.name')
                    ->from($this->getTableName('category') .' AS category')
                    ->where('category.id=' . (int)$service->category_id);
                $service->category_name = $db->setQuery($query)->loadResult();
            }
            return $list_service;
        }
        return array();
    }

}
