<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

class ReviewsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "reviews";
    /**
     * @var string
     */
    public $table_name = "review";

    public function renderReviewHtmlAjax() {
        $input = Factory::getInput();
        $service_id = $input->getInt('service_id', 0);
        $limit = $input->getInt('limit',  0);
        $start = $input->getInt('start',  0);
        $total_result = $input->getInt('total_result',  0);
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('review.*')
            ->from($this->getTableName('review').' AS review')
            ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
            ->where('service_review.service_id='.(int)$service_id)
            ->where('review.published=1')
        ;
        $list_review = $this->_db->setQuery($query, $start* $limit, (($total_result - $start * $limit) > $limit)?$limit: ($total_result - $start * $limit))->loadObjectList();
        foreach ($list_review as $review) {
            $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
            $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
            $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
            $rating_value = isset($review->rating_value)?$review->rating_value:0;
            $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
        }
        ob_start();
        foreach ($list_review as $review_item) {
            ?>
            <div class="block-review-item">

                <div class="img-block">
                    <div>
                        <img src="<?php echo (Factory::getRootUrlPlugin())?>frontend/app/assets/images/avatar-reviewer.jpg" alt="avatar-reviewer">
                    </div>
                </div>
                <div class="block-content">
                    <h5><?php echo (esc_html(isset($review_item->name)?$review_item->name:''))?></h5>
                    <ul class="list-rating-star">
                        <?php $list_star_sum_review = HtmlFrontend::get_rating_star($review_item->avg_rating);?>
                        <?php for ($i=0; $i < $list_star_sum_review[0]; $i++) {?>
                            <li class="item-star"><i class="fas fa-star"></i></li>
                        <?php }?>
                        <?php for ($i=0; $i < $list_star_sum_review[1]; $i++) {?>
                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                        <?php }?>
                        <?php for ($i=0; $i < $list_star_sum_review[2]; $i++) {?>
                            <li class="item-star"><i class="far fa-star"></i></li>
                        <?php }?>
                    </ul>
                    <p><?php echo (esc_html(isset($review_item->comments)?$review_item->comments:''))?></p>
                </div>
                <div class="block-time-review">
                    <h6><?php esc_html_e('Visited', 'wpbookingpro');?> <?php echo (esc_html(date('F d, Y',strtotime($review_item->created_date))))?></h6>
                </div>
            </div>
            <?php
        }
        $content = ob_get_clean();
        return $content;
    }

    public function getListReviewVendor() {
        if(is_user_logged_in()) {
            $modelUser = Model::getInstance('user');
            $user = $modelUser->getUserInfo();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('vendor_review'). ' AS vendor_review ON vendor_review.review_id=review.id')
                ->where('vendor_review.user_id='.(int)$user->data->user_plugin->id)
            ;

            $list_review = $db->setQuery($query)->loadObjectList();
            return $list_review;

        }
        return array();
    }

    public function getListReviewService() {
        if(is_user_logged_in()) {
            $modelUser = Model::getInstance('user');
            $user = $modelUser->getUserInfo();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review').' AS review')
                ->leftJoin($this->getTableName('service_review'). ' AS service_review ON service_review.review_id=review.id')
                ->leftJoin($this->getTableName('service'). ' AS service ON service.id=service_review.service_id')
                ->where('service.user_id='.(int)$user->data->user_plugin->id)
            ;

            $list_review = $db->setQuery($query)->loadObjectList();
            foreach ($list_review as &$item) {
                $rating_ambience = isset($item->rating_ambience)?$item->rating_ambience:0;
                $rating_cleanliness = isset($item->rating_cleanliness)?$item->rating_cleanliness:0;
                $rating_staff = isset($item->rating_staff)?$item->rating_staff:0;
                $rating_value = isset($item->rating_value)?$item->rating_value:0;
                $item->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
            }
            return $list_review;

        }
        return array();
    }


}
