<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class LocationsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "locations";
    /**
     * @var string
     */
    public $table_name = "location";

    public function getList()
    {
        if(is_user_logged_in()) {
            $modelUser = Model::getInstance('user');
            $user = $modelUser->getUserInfo();
            $db = Factory::getDBO();
            $query = $db->getQuery(true)
                ->select("location.*")
                ->from($this->getTableName('location').' AS location')
                ->leftJoin($this->getTableName('state').' AS state ON state.id=location.state_id')
                ->select('state.name AS state_name')
                ->leftJoin($this->getTableName('country'). ' AS country ON country.id=state.country_id')
                ->select('country.countryname AS country_name')
                ->where('location.user_id='.(int)$user->data->user_plugin->id)
            ;

            return $db->setQuery($query)->loadObjectList();
        }
        return array();

    }
    public function getListLocationByUser(){
        if(is_user_logged_in()) {
            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $user = wp_get_current_user();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('user.id')
                ->from($this->getTableName('user') .' AS user')
                ->where('user.open_source_user_id	='.(int)$user->ID)
            ;
            $user_id_plugin = $db->setQuery($query)->loadResult();

            $query->clear()
                ->select('*')
                ->from($this->getTableName('location'))
                ->where('user_id='.(int)$user_id_plugin)
            ;
            $list_location = $db->setQuery($query)->loadObjectList();

            return $list_location;
        }
        return array();
    }
}
