<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class EmployeesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "employees";
    /**
     * @var string
     */
    public $table_name = "employee";

    public function getListEmployeeByUser(){
        if(is_user_logged_in()) {
            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $user = wp_get_current_user();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('user.id')
                ->from($this->getTableName('user') .' AS user')
                ->where('user.open_source_user_id	='.(int)$user->ID)
            ;
            $user_id_plugin = $db->setQuery($query)->loadResult();

            $query->clear()
                ->select('*')
                ->from($this->getTableName('employee'))
                ->where('user_id='.(int)$user_id_plugin)
            ;
            $list_employee = $db->setQuery($query)->loadObjectList();

            return $list_employee;
        }
        return array();
    }

}
