<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class CategoriesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "categories";
    /**
     * @var string
     */
    public $table_name = "category";

    public function getListQuery()
    {

        $query=$this->db->getQuery(true);
        $query->select("a.*")
            ->from($this->getTableName().' AS a')
            ->where('a.published=1')

        ;
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));

        return $query;
    }

    public function getList()
    {
        $list = parent::getList(); // TODO: Change the autogenerated stub
        $db = Factory::getDBO();
        $query = $this->db->getQuery(true);
        foreach ($list as &$category) {
            $query->clear()
                ->select('service.*')
                ->from($this->getTableName('service') . ' AS service')
                ->where('service.category_id=' . (int)$category->id)
                ->where('service.published=1')
            ;
            $list_service = $db->setQuery($query)->loadObjectList();
            foreach (  $list_service as &$service) {
                $query->clear()
                    ->select('service_employee.*')
                    ->from($this->getTableName('service_employee').' AS service_employee')
                    ->where('service_employee.service_id='.(int)$service->id)
                ;
                $list_employee = $db->setQuery($query)->loadObjectList();
                $service->list_employee = $list_employee;
            }
            $category->list_service = $list_service;
        }
        return $list;
    }
    public function getListCategoryByUser(){
        if(is_user_logged_in()) {
            $user_id = isset($_SESSION['user_id']) ? sanitize_text_field($_SESSION['user_id']) : '';
            $user = wp_get_current_user();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('user.id')
                ->from($this->getTableName('user') .' AS user')
                ->where('user.open_source_user_id	='.(int)$user->ID)
                ;
            $user_id_plugin = $db->setQuery($query)->loadResult();
            
            $query->clear()
                ->select('*')
                ->from($this->getTableName('category'))
                ->where('user_id='.(int)$user_id_plugin)
            ;
            $list_category = $db->setQuery($query)->loadObjectList();
            foreach ($list_category as &$category) {
                $query->clear()
                    ->select('service.*')
                    ->from($this->getTableName('service').' AS service')
                    ->where('service.category_id ='.(int)$category->id)
                    ->where('service.published=1')
                ;
                $list_service = $db->setQuery($query)->loadObjectList();
                foreach ($list_service as &$service) {
                    $query->clear()
                        ->select('service_employee.*')
                        ->from($this->getTableName('service_employee').' AS service_employee')
                        ->where('service_employee.service_id='.(int)$service->id)
                    ;
                    $list_employee = $db->setQuery($query)->loadObjectList();
                    $service->list_employee = $list_employee;
                }
                $category->list_service = $list_service;
            }
            return $list_category;
        }
        return array();
    }
}
