<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();

$id_by_name = "element_field_". $name;
$name_of_field = str_replace(array('[', ']'), '_', $name);
if(is_user_logged_in()) {
    $modelUser = Model::getInstance('user');
    $user = $modelUser->getUserInfo();
    $value = $user->data->user_plugin->image;
}
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-userimage">
        <div class="show-image">
            <div>
                <img class="media-show" src="<?php echo (esc_url($value)) ?>">
            </div>
        </div>
        <button class="btn-browser-media" type="button">
            <i class="fas fa-cloud-upload-alt"></i>
            <?php esc_attr_e('Upload image','wpbookingpro') ?>
        </button>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>"  class="form-control" >
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_userimage',array(
    "input_name"=>  $name,
    "multiple"=>  $multiple,
),'frontend/app/layouts/WooBooking/form/field/userimage/userimage.jquery.js');
