<?php
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$modelCategories = Model::getInstance('categories');
$list = $modelCategories->getListCategoryByUser();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-servicecategory">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo($multiple ? ' multiple ' : '')  ?>
                class="list-servicecategory">
            <option value=""><?php esc_html_e('Select category','wpbookingpro') ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo($item->id == $value ? ' selected ' : ''); ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php echo (esc_html($item->name)); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-servicecategory','field_servicecategory',array(
    "field_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/servicecategory/servicecategory.jquery.js');
