<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-rating-star">
        <div class='rating-stars ambience'>
            <h5><?php esc_html_e('Rating ambience','wpbookingpro');?></h5>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($field_name_rating_ambience));?>">
        </div>
        <div class='rating-stars cleanliness'>
            <h5><?php esc_html_e('Rating cleanliness','wpbookingpro');?></h5>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($field_name_rating_cleanliness));?>">
        </div>
        <div class='rating-stars staff'>
            <h5><?php esc_html_e('Rating staff','wpbookingpro');?></h5>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($field_name_rating_staff));?>">
        </div>
        <div class='rating-stars value'>
            <h5><?php esc_html_e('Rating value','wpbookingpro');?></h5>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($field_name_rating_value));?>">
        </div>

    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-rating-star','field_ratingstar',array(
        "field_name_rating_ambience"=>$field_name_rating_ambience,
        "field_name_rating_cleanliness"=>$field_name_rating_cleanliness,
        "field_name_rating_staff"=>$field_name_rating_staff,
        "field_name_rating_value"=>$field_name_rating_value,
),'frontend/app/layouts/WooBooking/form/field/ratingstar/ratingstar.js');