<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-radius">
        <div class="wrapper-radius">
            <input type="text" value="<?php echo (esc_attr($value)) ?>" class="form-control radius">
            <input type="hidden" required="<?php echo (esc_attr($required)) ?>"
                   name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>">
        </div>
    </div>
<?php
$doc->addScriptApplySelector('#'.$id_by_name,'field_radius',array(
    "input_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/radius/jquery.radius.js');
