<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
	$item->text = $item->countrycode;
}

$uri = Factory::getUri();
$layout = $uri->getVar('layout','');
$id = $uri->getVar('id', '');
$service_id = $uri->getVar('service_id', '');
if(is_user_logged_in()) {
    if($layout == "account-setting" || trim($service_id) != '' && $service_id > 0) {
        $modelUser = Model::getInstance('user');
        $user = $modelUser->getUserInfo();
        $phone_code = $user->data->user_plugin->phonecode;
        $country_code = $user->data->user_plugin->countrycode;
        $value = $user->data->user_plugin->mobile;
    } elseif($layout=="my-location" && trim($id) != '' && $id > 0) {
        $modelLocation = Model::getInstance('location');
        $location = $modelLocation->getItem($id);
        $phone_code = $location->phonecode;
        $country_code = $location->countrycode;
        $value = $location->mobile;
    } elseif($layout=="my-customer" && trim($id) != '' && $id > 0) {
        $modelCustomer = Model::getInstance('customer');
        $customer = $modelCustomer->getItem($id);
        $phone_code = $customer->phonecode;
        $country_code = $customer->countrycode;
        $value = $customer->mobile;
    } elseif($layout=="my-service" && trim($id) != '' && $id > 0) {
        $modelService = Model::getInstance('service');
        $service = $modelService->getItem($id);
        $phone_code = $service->phonecode;
        $country_code = $service->countrycode;
        $value = $service->mobile;
    } elseif($layout=="my-employee" && trim($id) != '' && $id > 0) {
        $modelEmployee = Model::getInstance('employee');
        $employee = $modelEmployee->getItem($id);
        $phone_code = $employee->phonecode;
        $country_code = $employee->countrycode;
        $value = $employee->mobile;
    } else {
        $phone_code = $default_phone_code;
        $current_country="United States";
        $country_code = "USA";
    }

} else {
    $phone_code = $default_phone_code;
    $current_country="United States";
    $country_code = "USA";
}





?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input class="countries" value="" type="text">
            <input type="hidden" name="<?php echo (esc_attr($field_name_phone_code)) ?>" value="<?php echo (esc_attr($phone_code)) ?>">
            <input type="hidden" name="<?php echo (esc_attr($field_name_countrycode)) ?>" value="<?php echo (esc_attr($country_code)) ?>">
            <input class="phone_number" name="<?php esc_attr_e($name); ?>" value="<?php echo (esc_attr($value)) ?>" type="text">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
    "field_name_phone_code"=>$field_name_phone_code,
    "field_name_countrycode"=>$field_name_countrycode,
    "phonecode"=>$phone_code,
    "countrycode"=>$country_code,
),'frontend/app/layouts/WooBooking/form/field/phonenumber/phonenumber.jquery.js');