<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$locationsModel = Model::getInstance('locations');
$list_location = $locationsModel->getListLocationByUser();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-location">
        <select name="<?php echo (esc_attr($name)); ?>" <?php $multiple ? ' multiple ' : null ?>
                class="form-control list-location">
            <option value=""></option><?php esc_html_e('Select location','wpbookingpro');?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo ($value == $location->id ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($location->id)); ?>"><?php echo (esc_html($location->address)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-location','field_location',array(
),'frontend/app/layouts/WooBooking/form/field/location/location.jquery.js');
