<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\FrontendHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$input= Factory::getInput();
$service_id= $input->getInt('service_id',0);
$modelService = Model::getInstance('service');
$service_item = $modelService->getItem($service_id);
$list_employee = $modelService->getEmployeeByServiceId($service_id);
$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-employeeimageslider">
        <div class="row">
            <div class="col-md-12">
                <div class="wrapper-employee-block">
                    <div class="list-employee">
                        <?php foreach ($list_employee as $item) { ?>
                            <div class="wrapper-employee" data-employee_id="<?php esc_html_e($item->id); ?>">
                                <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                                <div class="img-box">
                                    <div>
                                        <?php $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $item->image);?>
                                        <?php if($check_user_demo['is_demo']) {?>
                                            <?php if($check_image_size) {?>
                                                <img class="employee-image" src="<?php echo (esc_url($uploads['baseurl'].'/'.$item->image)); ?>" alt="employee-image" />
                                            <?php } else {?>
                                                <img class="employee-image" src="<?php echo (esc_url(Factory::getRootUrlPlugin().$item->image)); ?>" alt="employee-image" />
                                            <?php } ?>

                                        <?php } else {?>
                                            <img class="employee-image" src="<?php echo (esc_url(Factory::getRootUrlPlugin().$item->image)); ?>" alt="employee-image" />
                                        <?php } ?>
                                    </div>
                                </div>
                                <p><?php esc_html_e($item->full_name); ?></p>
                            </div>
                        <?php } ?>
                    </div>
                    <span class="left-direction"><i class="icon-nb-down-arrow"></i></span>
                    <span class="right-direction"><i class="icon-nb-down-arrow"></i></span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <table class="table-info-custom" style="display: none">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('From','wpbookingpro');?></th>
                            <th><?php esc_html_e('To','wpbookingpro');?></th>
                            <th><?php esc_html_e('Price','wpbookingpro');?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <input type="hidden" name="<?php esc_html_e($name); ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-employeeimageslider','field_employeeimageslider',array(
    "field_name"=>  $name,
    "list_employee"=>$list_employee,
    "service_item"=>$service_item
),'frontend/app/layouts/WooBooking/form/field/employeeimageslider/employeeimageslider.jquery.js');