"use strict";
(function ($) {
    $.field_employeeimageslider = function (element, options) {
        var defaults = {
            field_name: 0,
            list_employee:[],
            service_item:[]
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            let list_employee = plugin.settings.list_employee;
            let service_item = plugin.settings.service_item;
            setTimeout(function () {
                $element.find('.list-employee').slick({
                    infinite: false,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    prevArrow: ".left-direction",
                    nextArrow: ".right-direction",
                    responsive: [
                        {
                            breakpoint: 1200,
                            settings: {
                                arrows: false,
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                arrows: false,
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                arrows: false,
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                arrows: false,
                                dots:true,
                                slidesToShow: 1,
                                slidesToScroll: 1,
                            }
                        }
                    ]
                });

            },10);
            $element.find('.list-employee').on('breakpoint', function(event, slick, breakpoint) {
                $element.find('.wrapper-employee').click(function (e) {
                    let $self = $(this);
                    $element.find('.wrapper-employee .selected').hide();
                    $element.find('.wrapper-employee p').removeClass('active');
                    let employee_id = $self.data('employee_id');
                    $self.find('.selected').show();
                    $self.find('p').addClass('active');
                    $element.find(`input[name="${field_name}"]`).val(employee_id).trigger('change');
                    let $table_info_custom = $element.find('table.table-info-custom');
                    let $tbody = $table_info_custom.find('tbody');
                    $tbody.empty();
                    $.each(list_employee, function (index, item) {
                        let start_time = moment(item.start_time,'HH:mm:ss');
                        let end_time = moment(item.end_time,'HH:mm:ss');
                        if(parseInt(item.id) === employee_id) {
                            if(start_time.valueOf() < end_time.valueOf()) {
                                let $tr = `
                                <tr>
                                    <td>${item.start_time}</td>
                                    <td>${item.end_time}</td>
                                    <td>$ ${item.price}</td>
                                </tr>
                            `;
                                $tbody.append($tr);
                            } else {
                                let $tr = `
                                <tr>
                                    <td colspan="2">Time not set</td>
                                    <td>$ ${service_item.price}</td>
                                </tr>
                            `;
                                $tbody.append($tr);
                            }
                        }
                    });
                });
            });
            $element.find('.wrapper-employee').on('click',function (e) {
                let $self = $(this);
                $element.find('.wrapper-employee .selected').hide();
                $element.find('.wrapper-employee p').removeClass('active');
                let employee_id = $self.data('employee_id');
                $self.find('.selected').show();
                $self.find('p').addClass('active');
                $element.find(`input[name="${field_name}"]`).val(employee_id).trigger('change');
                let $table_info_custom = $element.find('table.table-info-custom');
                $table_info_custom.show();
                let $tbody = $table_info_custom.find('tbody');
                $tbody.empty();
                $.each(list_employee, function (index, item) {
                    let start_time = moment(item.start_time,'HH:mm:ss');
                    let end_time = moment(item.end_time,'HH:mm:ss');
                    if(parseInt(item.id) === employee_id) {
                        if(start_time.valueOf() < end_time.valueOf()) {
                            let $tr = `
                                <tr>
                                    <td>${item.start_time}</td>
                                    <td>${item.end_time}</td>
                                    <td>$ ${item.price}</td>
                                </tr>
                            `;
                            $tbody.append($tr);
                        } else {
                            let $tr = `
                                <tr>
                                    <td colspan="2">Time not set</td>
                                    <td>$ ${service_item.price}</td>
                                </tr>
                            `;
                            $tbody.append($tr);
                        }
                    }
                });
            });
        };
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`input[name="${field_name}"]`).val();
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_employeeimageslider = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_employeeimageslider')) {
                var plugin = new $.field_employeeimageslider(this, options);
                $(this).data('field_employeeimageslider', plugin);
            }
        });
    }
})(jQuery);
