"use strict";
(function ($) {
    $.field_birthday = function (element, options) {
        var defaults = {
            input_name: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[id="birthday"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD'
                },
                maxYear: '+10',
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name}"]`).val(start.format('YYYY-MM-DD'));
            });
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_birthday = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_birthday')) {
                var plugin = new $.field_birthday(this, options);
                $(this).data('field_birthday', plugin);
            }
        });
    }
})(jQuery);
