<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class UserController extends ControllerFrontend
{
    public function logout_account() {
        $input = Factory::getInput();
        $page_login = $input->getString('page_login','');
        add_action('init',array($this,'logout_action'));
        Utility::redirect($page_login.'?logout_message=success');
    }

    function logout_action() {
        if ( is_user_logged_in() ) {
            global $sessions;
            wp_logout();
            session_destroy();
            $sessions->destroy_all();//destroys all sessions
            wp_clear_auth_cookie();//clears cookies regarding WP Auth
        }
    }

    public function edit_user_account() {
        $input = Factory::getInput();
        $data = $input->getData();
        $modelUser = Model::getInstance('user');
        $modelUser->editInfoUserAccount($data);
    }

    public function check_old_user_pass() {
        if(!function_exists('wp_get_current_user')) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        $input = Factory::getInput();
        $data = $input->getData();
        $dataObj = isset($data['dataObj'])?$data['dataObj']:array();
        $old_pass = isset($dataObj['old_pass'])?$dataObj['old_pass']:'';
        $user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:'';
        $user_login = isset($_SESSION['user_login'])?$_SESSION['user_login']:'';
        $user = get_user_by('login', $user_login );
        if(wp_check_password($old_pass, $user->data->user_pass, $user_id)) {
            return true;
        }
        return false;
    }

}
