<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Router\Route;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class ServicesController extends ControllerFrontend
{
    public function ajax_get_list_service()
    {
        if(!function_exists('wp_get_current_user')) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        $input = Factory::getInput();
        $data = $input->getData();
        foreach ($data as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            }
        }
        $modelServices=Model::getInstance('services');
        $list=$modelServices->get_list_service_loc();
        $check_user_demo = FrontendHelper::checkUserDemo();
        $uploads = wp_upload_dir();
        $appConfig = Factory::getAppConfig();
        $default_currency = $appConfig->get('default_currency','');
        $current_currency = isset($_SESSION['currency'])?$_SESSION['currency']: $default_currency;
        $rate = FrontendHelper::getExchangeRate($current_currency);
        $format = FrontendHelper::getFormatCurrentCurrency();
        foreach ($list as $item){

             //$item->category="Restaurant";
             $item->link= Route::_($data['link_service_detail'][0].'?service_id='.$item->id);
             $item->lng=$item->lang;
             $item->address="12509 Wayzata Blvd";
             $item->address2="";
             $item->decs= mb_strimwidth($item->description, 0, 35, "...");
             $item->city=$item->location->address;
             $item->ctg=$item->category->name;
             $item->state="MN";
             $item->postal="55305";
             $item->web="http:\/\/www.chipotle.com";
             if($check_user_demo['is_demo']) {
                 $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $item->image);
                if($check_image_size) {
                    $item->img= $uploads['baseurl'].'/'.$item->image ;
                } else {
                    $item->img=Factory::getRootUrlPlugin().$item->image ;
                }
             } else {
                 $item->img=Factory::getRootUrlPlugin().$item->image ;
             }

             $item->hours1="Mon-Sun 11am-10pm";
             $item->hours2="";
             $item->hours3="";
             $item->featured="";
             $item->features="Margaritas";
             $item->date="02/17/18";
             $item->fare=round($item->price * $rate, 2);
             $item->list_star_sum=HtmlFrontend::get_rating_star($item->rating_avg);
             $item->number_review=count($item->list_review);
             $item->is_user_logged_in = is_user_logged_in();
             $item->format_currency = $format;
        }

        echo json_encode($list);

        die;
    }

    public function get_list_service_ajax() {
        $input = Factory::getInput();
        $data =  $input->getData();
        $dataObj = isset($data['dataObj'])?$data['dataObj']:array();

        foreach ($dataObj as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            } else if(!is_array($value)) {
                $input->set($key, $value);
            }
        }

        $modelServices = Model::getInstance('services');
        $result = $modelServices->renderServiceHtmlAjax();
        return $result;
    }

}
