<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class ServiceController extends ControllerFrontend
{
    public function save($data = array())
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $modelService = Model::getInstance('service');
        $service = $modelService->save($data);
        $link_redirect = isset($data['link_redirect'])?$data['link_redirect']:'';
        Utility::redirect($link_redirect);
    }
    
    public function delete_service_ajax()
    {
        $input = Factory::getInput();
        $service_id = $input->getInt('service_id',0);
        $link_my_service = $input->getString('link_my_service','');
        $modelService = Model::getInstance('service');
        $modelService->delete($service_id);
        $db= Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->delete(Utility::getTableName('service_employee'))
            ->where('service_id='.(int)$service_id)
        ;
        $db->setQuery($query)->execute();

        $query->clear()
            ->delete(Utility::getTableName('service_coupon'))
            ->where('service_id='.(int)$service_id)
        ;
        $db->setQuery($query)->execute();

        $query->clear()
            ->delete(Utility::getTableName('service_review'))
            ->where('service_id='.(int)$service_id)
        ;
        $db->setQuery($query)->execute();
        Utility::redirect($link_my_service);
    }

    public function set_currency()
    {
        $input=Factory::getInput();
        $currency = $input->getString('currency','');
        $_SESSION['currency'] = $currency;

    }

}
