<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class ReviewController extends ControllerFrontend
{
    public function save_review()
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $link_redirect = isset($data['link_redirect'])?$data['link_redirect']:'';
        $modelReview = Model::getInstance('review');
        $review = $modelReview->save_review($data);
        Utility::redirect($link_redirect);

    }

    public function delete($id = 0)
    {
        $input = Factory::getInput();
        $review_id = $input->getInt('review_id',0);
        $page_my_review = $input->getString('page_my_review','');
        $modelReview = Model::getInstance('review');
        $modelReview->delete($review_id);
        $db= Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->delete(Utility::getTableName('service_review'))
            ->where('review_id='.(int)$review_id)
        ;
        $db->setQuery($query)->execute();
        $query->clear()
            ->delete(Utility::getTableName('vendor_review'))
            ->where('review_id='.(int)$review_id)
        ;
        $db->setQuery($query)->execute();

        Utility::redirect($page_my_review);
    }

    public function save($data = array())
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $data['rating_vendor'] = $input->getFloat('rating_vendor_number',0);
        $page_my_review = isset($data['page_my_review'])?$data['page_my_review']:'';
        $modelReview = Model::getInstance('review');
        $modelReview->save($data);
        Utility::redirect($page_my_review);
    }


}
