<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class CategoryController extends ControllerFrontend
{
    public function get_list_services_ajax(){
        $input = Factory::getInput();
        $data =  $input->getData();
        $dataObj = isset($data['dataObj'])?$data['dataObj']:array();

        foreach ($dataObj as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            } else if(!is_array($value)) {
                $input->set($key, $value);
            }
        }
        $modelCategory = Model::getInstance('category');
        $result = $modelCategory->renderServiceHtmlAjax();
        return $result;
    }
    public function save($data = array())
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $modelCategory = Model::getInstance('category');
        $category = $modelCategory->save($data);
        $link_redirect = isset($data['link_redirect'])?$data['link_redirect']:'';
        Utility::redirect($link_redirect);
        return parent::save($data); // TODO: Change the autogenerated stub
    }

    public function delete_category_ajax()
    {
        $input = Factory::getInput();
        $category_id = $input->getInt('category_id',0);
        $link_my_category = $input->getString('link_my_category','');
        $modelCategory = Model::getInstance('category');
        $modelCategory->delete($category_id);
        Utility::redirect($link_my_category);
    }

}
