"use strict";
(function ($) {
    $.view_list_vendors = function (element, options) {
        let defaults = {
            limit:'',
            total_result:''
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let limit = parseInt(plugin.settings.limit);
            let total_result = parseInt(plugin.settings.total_result);
            let items_per_page = limit;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page < 2) ? (total_page % 2): 2;

            $element.find('.pagination-vendors').twbsPagination({
                totalPages:(total_page === 0)?1:total_page,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '<i class="fas fa-angle-double-left"></i>',
                prev: '<i class="fas fa-angle-left"></i>',
                next: '<i class="fas fa-angle-right"></i>',
                last: '<i class="fas fa-angle-double-right"></i>',
                onPageClick: function (event, page) {
                    let $form = $(this).closest('form[name="form-list_vendor"]');
                    $form.find('input[name="start"]').val(page -  1);
                    var output = plugin.convert_data_form($form);
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value;
                    });

                    $.ajax({
                        url: wpbookingpro_root_url+wpbookingpro_api_task,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            dataObj: dataObj,
                            task: "vendors.get_list_vendor_ajax"
                        },
                        beforeSend: function() {
                            $('body').loadingModal();
                        },
                        success: function(res) {
                            res = JSON.parse(res);
                            let result = res.data;
                            $form.find('.wrapper-list-vendor').empty();
                            $form.find('.wrapper-list-vendor').append(result);
                        },
                        error: function(xhr) { // if error occured

                        },
                        complete: function() {
                            $('body').loadingModal('destroy');

                        },
                    })
                }
            });
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function($form) {
            var dataArray = $form.serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_vendors = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_vendors')) {
                let plugin = new $.view_list_vendors(this, options);
                $(this).data('view_list_vendors', plugin);
            }
        });
    }
})(jQuery);
