<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List wishlist");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("wishlist.form")) ?>" name="admin-form" method="post">
        <div class="view-list-wishlist">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-wishlist-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-wishlist-th nowrap"><?php esc_html_e('Service name','wpbookingpro')?></th>
                        <th class="view-list-wishlist-th nowrap"><?php esc_html_e('User name','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="service-name nowrap"><?php echo (esc_html($item->service_name)); ?></td>
                        <td class="user-name nowrap"><?php echo (esc_html($item->user_name)); ?></td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("wishlist","wishlist.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-wishlist', 'view_list_wishlist', array(

), "admin/app/assets/js/view_list_wishlist.js");
?>