<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();

$item = $this->item;
$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->image);

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("employee.form")) ?>" name="admin-form" method="post">
        <div class="view-list-employee">
            <table id="vendor-employee" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('ID','wpbookingpro')?></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('Email','wpbookingpro')?></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('Phone','wpbookingpro')?></th>
                        <th class="view-list-employee-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_employee as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="name nowrap"><?php echo (esc_html(UtilityAlias::get_full_name($item->first_name, $item->last_name))); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <?php if($check_user_demo['is_demo']) {?>
                                        <?php if($check_image_size) {?>
                                            <img class="employee-image" src="<?php echo (esc_attr($uploads['baseurl'].'/'.$item->image)); ?>" alt="employee-image"/>
                                        <?php } else {?>
                                            <img class="employee-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().$item->image)); ?>" alt="employee-image"/>
                                        <?php } ?>

                                    <?php } else {?>
                                        <img class="employee-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().$item->image)); ?>" alt="employee-image"/>
                                    <?php } ?>
                                </div>
                            </div>
                        </td>
                        <td class="email nowrap"><?php echo (esc_html($item->email)); ?></td>
                        <td class="phone nowrap">
                            <?php
                            $mobile = isset($item->mobile)?$item->mobile:'';
                            if(trim($mobile)!= '' && $mobile['0'] == 0) {
                                $mobile = substr($mobile,1);
                            }
                            $phonecode = isset($item->phonecode)?$item->phonecode:'';
                            echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("employee.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("employee","employee.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
