<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

$doc = Factory::getDocument();
$input = Factory::getInput();
$id = $input->getInt('id',0);

?>
<div class="view-user-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('User details','wpbookingpro') ?></a></li>
                <li role="presentation" ><a href="#password" aria-controls="password" role="tab"
                                                          data-toggle="tab"> <?php esc_html_e('Edit password','wpbookingpro') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('group_user_id')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('user_name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('first_name')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('last_name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('email')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('mobile')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('gender')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('birthday')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('company')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('business')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('address')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('address_bill')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('country')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('city')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('state')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('postcode')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="password">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('user_pass');
                            echo ($field->input);
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>

<?php
$doc->addScriptApplySelector('.view-user-form','view_form_user', array(
    "is_new_user"=> ($id > 0 && trim($id) != '') ? false : true,
    "id"=>$id
),'admin/app/assets/js/view_form_user.js');
