<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List sms content");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("smscontent.form")) ?>" name="admin-form" method="post">
        <div class="view-list-smscontent">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('ID','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Action','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Title','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('SMS Content','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="sms-content-id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="action-sms nowrap"><?php echo (esc_html($item->action_sms)); ?></td>
                        <td class="title-sms nowrap"><?php echo (esc_html($item->title_sms)); ?></td>
                        <td class="content-sms nowrap"><?php echo (esc_html($item->content_sms)); ?></td>
                        <td class="sms-content-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("smscontent.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("smscontent","smscontent.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-smscontent', 'view_list_smscontent', array(

), "admin/app/assets/js/view_list_smscontent.js");
?>