<?php

namespace WpBookingProAdmin\app\views\smscontent;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class SmscontentView extends View
{
    public function display($tpl)
    {
        $modelsmscontent = Model::getInstance("smscontent");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("smscontent.add");
                ToolBar::delete("smscontent.delete_list");
                ToolBar::_clone("smscontent.clone_list");
                $model = Model::getInstance("smscontents");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit smscontent');
                ToolBar::apply("smscontent.apply");
                ToolBar::save("smscontent.save");
                ToolBar::cancel("smscontent.cancel");
                ToolBar::back_to_list("smscontent.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelsmscontent->getItem($id);
                $this->form = $modelsmscontent->getForm();
                break;
        }
        return parent::display($tpl);
    }
}