<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List sms");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("sms.form")) ?>" name="admin-form" method="post">
        <div class="view-list-sms">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-sms-th nowrap"><?php esc_html_e('Account ID','wpbookingpro')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_html_e('Auth Token','wpbookingpro')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_html_e('Phone register','wpbookingpro')?></th>
                        <th class="view-list-sms-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="account-id nowrap"><?php echo (esc_html($item->account_id)); ?></td>
                        <td class="auth-token nowrap"><?php echo (esc_html($item->auth_token)); ?></td>
                        <td class="phone-register nowrap">
                            <?php
                                $phone_register = isset($item->phone_register)?$item->phone_register:'';
                                if($phone_register['0'] == 0) {
                                    $phone_register = substr($phone_register,1);
                                }
                                $phonecode = isset($item->phonecode)?$item->phonecode:'';
                                echo (esc_html('+'.$phonecode . $phone_register));
                            ?>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro'); ?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookingpro'); ?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="sms-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("sms.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("sms","sms.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
