<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List service");
ob_start();
$this->loadTemplate('list_service_item');
$html_service_item = ob_get_clean();
ob_start();
$this->loadTemplate('list_category_item');
$html_category_item = ob_get_clean();

$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);
?>
<?php ?>
    <form action="" name="admin-form" method="post">
        <div class="view-list-service">
            <div class="list-service-service main-table">
                <div class="row">
                    <div class="col-md-3">
                        <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                        <select  id="searchByVendor" name="user_id">
                            <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                            <?php foreach ($this->list_vendor as $vendor_item) {?>
                                <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                    <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                                </option>
                            <?php }?>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <h4><?php esc_html_e('All categories','wpbookingpro') ?></h4>
                        <div class="list-category nav nav-tabs" role="tablist">
                            <?php foreach ($this->list_service_by_category as $index_category=>  $category) { ?>
                                <?php $this->item=$category ?>
                                <?php $this->index_category=$index_category ?>
                                <?php  $this->loadTemplate('list_category_item') ?>
                            <?php } ?>
                        </div>
                        <a class="btn btn-primary btn-block btn-add-category" href="<?php echo(UtilityAlias::goToTaskByView("category","category.add")) ?>"><i class="far fa-plus-square"></i><?php esc_attr_e('Add category','wpbookingpro') ?></a>
                    </div>
                    <div class="col-md-8">
                        <h4><?php esc_html_e('All services','wpbookingpro') ?></h4>
                        <div class="wrapper-list-service-by-category tab-content">
                            <?php foreach ($this->list_service_by_category as $index_category => $category) { ?>
                                <div class="list-service-by-category tab-pane <?php echo (esc_attr($index_category == 0 ? ' active ' : null)) ?>"
                                     role="tabpanel" id="tab-category-<?php echo (esc_attr($category->id)); ?>"
                                     data-category_id="<?php echo (esc_attr($category->id)); ?>">
                                    <?php foreach ($category->list_service as $service) { ?>
                                        <?php $this->item=$service ?>
                                        <?php  $this->loadTemplate('list_service_item') ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="">
    </form>