<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List review");

$input = FactoryAlias::getInput();
$user_id  = $input->getInt('user_id',0);
?>
<?php ?>
    <form action="" name="admin-form" method="post">
        <div class="view-list-review">
            <div class="row">
                <div class="col-md-3">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Email','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Target','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Rating','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Comments','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="email nowrap"><?php echo (esc_html($item->email)); ?></td>
                        <td class="target nowrap">
                            <?php
                            if($item->service_id) {
                                esc_html_e('Service','wpbookingpro');
                            } elseif($item->user_id) {
                                esc_html_e('Vendor','wpbookingpro');
                            }
                            ?>
                        </td>
                        <td class="rating nowrap">
                            <?php
                            if($item->service_id) {
                                echo (esc_html($item->avg_rating));
                            } elseif($item->user_id) {
                                echo (esc_html($item->rating_vendor));
                            }
                            ?>
                        </td>
                        <td class="comments nowrap">
                            <span>
                                <?php echo (esc_html($item->comments)); ?>
                            </span>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public', 'wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public', 'wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="review-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("review.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("review","review.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>