<?php

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Folder;
use WpBookingPro\Utilities\Utility;

$list_folder_payment_path = WPBOOKINGPRO_PATH_ROOT . "/lib/payments";
$folders = Folder::folders($list_folder_payment_path);
?>
<div id="view-payment-block" class="view-payment-form">
    <div class="block-alert"></div>
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">
        <div class="form-select-payment">
            <div class="form-input-info-header">
                <h4 class="modal-title"><?php esc_html_e('List payments','wpbookingpro') ?></h4>
            </div>
            <div class="form-input-info-body">
                <ul class="list-folder-payment">
                    <?php foreach ($folders as $folder) { ?>
                        <li>
                            <input type="radio" name="radio-select" id="<?php echo (esc_attr($folder)) ?>" value="<?php echo (esc_attr($folder)) ?>" />
                            <label for="<?php echo (esc_attr($folder)) ?>"><?php echo (esc_html($folder)) ?></label>
                        </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="form-input-info-footer">
                <a href="<?php echo(Utility::getBackendGoToLink("payment.list")) ?>" class="btn-cancel" ><?php esc_html_e('Cancel','wpbookingpro')?></a>
                <button type="submit" class="btn btn-primary btn-payment-modal-now"><?php esc_html_e('Submit','wpbookingpro') ?></span></button>
            </div>
        </div>
        <input type="hidden" name="payment">
        <input type="hidden" name="task" value="payment.ajax_create_payment_by_payment_name">
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.view-payment-form', 'view_form_payment', array(
), "admin/app/assets/js/view_form_payment.js");
