<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List Orderpackages");
?>
<?php ?>
<form action="<?php echo(UtilityAlias::getBackendGoToLink("orderpackages.form")) ?>" name="admin-form" method="post">
    <div class="view-list-order-package">
        <div class="wrapper-table-package">
            <table id="example" class="display table">
                <thead>
                    <tr class="header">
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Package','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Customer','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Payment','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Status','wpbookingpro') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item) { ?>
                        <tr class="row-item-order table-warning" data-order_id="<?php echo (esc_attr($item->id)) ?>">
                            <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                            <td class="nowrap"><?php echo (esc_html($item->package->name)); ?></td>
                            <td class="nowrap"><?php echo (esc_html($item->customer->customer_full_name)); ?></td>
                            <td class="nowrap"><?php echo (esc_html(HtmlBackend::render_price($item->total))); ?></td>
                            <td class="nowrap">
                                <div class="list-order-status">
                                    <select class="order-status">
                                        <?php foreach ($this->list_order_status as $order_status) { ?>
                                            <option <?php echo (esc_attr((isset($item->open_source_order_status_id)&&$order_status->open_source_order_status_id == $item->open_source_order_status_id) ? ' selected ' : '')) ?>
                                                    value="<?php echo (esc_attr($order_status->open_source_order_status_id)); ?>"><?php echo (esc_html($order_status->title)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </td>
                            <td>
                                <a href="<?php echo(UtilityAlias::getBackendGoToLink("orderpackages.form",array('id'=>$item->id))) ?>" class="btn btn-primary btn-detail" title="<?php esc_attr_e('Detail','wpbookingpro')?>"><?php esc_attr_e('Detail','wpbookingpro')?></a>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</form>