<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List groupuser");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("groupuser.form")) ?>" name="admin-form" method="post">
        <div class="view-list-groupuser">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-groupuser-th nowrap"><?php esc_html_e('ID','wpbookingpro')?></th>
                        <th class="view-list-groupuser-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-groupuser-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("groupuser.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("groupuser","groupuser.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>