<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List Event");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("event.form")) ?>" name="admin-form" method="post">
        <div class="view-list-event">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Total order','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_html_e('Spots','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_html_e('Min max', 'wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_html_e('Recurring','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Booking opens','wpbookingpro') ?> </th>
                        <th class="nowrap"><?php esc_html_e('Booking close','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('Status','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_html_e('ID','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 0; ?>
                    <?php foreach ($this->list as $item) { ?>
                        <?php
                            $item->index = $i;
                            $this->item = $item;
                            $this->loadTemplate('list_item');
                            $i++;
                        ?>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-event', 'view_list_event', array(

), "admin/app/assets/js/view_list_event.js");
?>