<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$doc = FactoryAlias::getDocument();
//report_wp_org
// WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Employee");
// WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
// WpBookingProHtmlBackendAlias::load_jquery_library('select2');
$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);
?>
<?php ?>
    <form action="" name="admin-form" method="post">
        <div class="view-list-employee">
            <div class="list-employee main-table">
                <div class="row">
                    <div class="col-md-3">
                        <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                        <select  id="searchByVendor" name="user_id">
                            <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                            <?php foreach ($this->list_vendor as $vendor_item) {?>
                                <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                    <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                                </option>
                            <?php }?>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <?php foreach ($this->list as $item) { ?>
                        <div class=" col-sm-6 col-md-4 col-xl-4">
                            <?php $this->item=$item ?>
                            <?php  $this->loadTemplate('list_item') ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
// $doc->addLessStyleSheet('admin/app/assets/less/view_list_employee.less');
// $doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
// $doc->addScriptApplySelector('.view-list-employee', 'view_list_employee', array(

// ), "admin/app/assets/js/view_list_employee.js");
?>