<?php

namespace WpBookingProAdmin\app\views\employee;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class EmployeeView extends View
{
    public function display($tpl)
    {
        $modelEmployee = Model::getInstance("employee");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("employee.add");
                ToolBar::delete("employee.delete_list");
                ToolBar::_clone("employee.clone_list");
                $model = Model::getInstance("employees");
                $this->list = $model->getList();
                $modelVendors = Model::getInstance('vendors');
                $this->list_vendor = $modelVendors->getListVendor();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit employee');
                ToolBar::apply("employee.apply");
                ToolBar::save("employee.save");
                ToolBar::cancel("employee.cancel");
                ToolBar::back_to_list("employee.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelEmployee->getItem($id);
                $this->form = $modelEmployee->getForm();
                break;
        }
        return parent::display($tpl);
    }
}