<?php
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List Customize");
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("customize.form")) ?>" name="admin-form" method="post">
        <div class="view-list-customize">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php esc_html_e('Table','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Label','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Field','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Type','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Backend','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Frontend','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Default value','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="customize-table">
                            <?php echo (esc_html (ucfirst($item->table_view))); ?>
                        </td>
                        <td class="customize-label">
                            <?php echo (esc_html ($item->label_field)); ?>
                        </td>
                        <td class="customize-field">
                            <?php echo (esc_html ($item->field_name)); ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->type)); ?>
                        </td>
                        <td class="customize-backend">
                            <?php if ($item->backend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-frontend">
                            <?php if ($item->frontend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->default_value)); ?>
                        </td>

                        <td class="customize-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("customize.form",array("id"=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView('customize','customize.delete',array("id"=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customize.add">
    </form>