<?php

namespace WpBookingProAdmin\app\views\customers;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class CustomersView extends View
{
    public function display($tpl)
    {
        $modelCustomer = Model::getInstance("customer");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customer.add");
                ToolBar::_clone("customer.clone_list");
                ToolBar::delete("customer.delete_list");
                $model = Model::getInstance("customers");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit Customer');
                ToolBar::save('customer.save');
                ToolBar::back_to_list('customer.back_to_list');
                ToolBar::cancel('customer.cancel');
                ToolBar::apply('customer.apply');
                $id = $input->getInt('id', 0);
                $this->item = $modelCustomer->getItem($id);
                $this->form = $modelCustomer->getForm();
                break;
        }
        return parent::display($tpl);
    }
}